/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractSimpleOperatorBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashAggregationOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.aggregation.AverageAggregations;
import com.facebook.presto.operator.aggregation.CountAggregation;
import com.facebook.presto.operator.aggregation.DoubleSumAggregation;
import com.facebook.presto.operator.aggregation.LongSumAggregation;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.util.DateTimeUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Optional;

public class HandTpchQuery1
extends AbstractSimpleOperatorBenchmark {
    public HandTpchQuery1(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hand_tpch_query_1", 1, 5);
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, "lineitem", "returnflag", "linestatus", "quantity", "extendedprice", "discount", "tax", "shipdate");
        TpchQuery1Operator.TpchQuery1OperatorFactory tpchQuery1Operator = new TpchQuery1Operator.TpchQuery1OperatorFactory(1);
        HashAggregationOperator.HashAggregationOperatorFactory aggregationOperator = new HashAggregationOperator.HashAggregationOperatorFactory(2, (List)ImmutableList.of((Object)tpchQuery1Operator.getTypes().get(0), (Object)tpchQuery1Operator.getTypes().get(1)), Ints.asList((int[])new int[]{0, 1}), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)LongSumAggregation.LONG_SUM.bind((List)ImmutableList.of((Object)2), Optional.empty(), Optional.empty(), 1.0), (Object)DoubleSumAggregation.DOUBLE_SUM.bind((List)ImmutableList.of((Object)3), Optional.empty(), Optional.empty(), 1.0), (Object)DoubleSumAggregation.DOUBLE_SUM.bind((List)ImmutableList.of((Object)4), Optional.empty(), Optional.empty(), 1.0), (Object)AverageAggregations.LONG_AVERAGE.bind((List)ImmutableList.of((Object)2), Optional.empty(), Optional.empty(), 1.0), (Object)AverageAggregations.DOUBLE_AVERAGE.bind((List)ImmutableList.of((Object)5), Optional.empty(), Optional.empty(), 1.0), (Object)AverageAggregations.DOUBLE_AVERAGE.bind((List)ImmutableList.of((Object)6), Optional.empty(), Optional.empty(), 1.0), (Object)CountAggregation.COUNT.bind((List)ImmutableList.of((Object)2), Optional.empty(), Optional.empty(), 1.0)), Optional.empty(), 10000, new DataSize(16.0, DataSize.Unit.MEGABYTE));
        return ImmutableList.of((Object)tableScanOperator, (Object)tpchQuery1Operator, (Object)aggregationOperator);
    }

    public static void main(String[] args) {
        new HandTpchQuery1(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }

    public static class TpchQuery1Operator
    implements Operator {
        private static final ImmutableList<Type> TYPES = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE);
        private final OperatorContext operatorContext;
        private final PageBuilder pageBuilder;
        private boolean finishing;
        private static final int MAX_SHIP_DATE = DateTimeUtils.parseDate((String)"1998-09-02");

        public TpchQuery1Operator(OperatorContext operatorContext) {
            this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
            this.pageBuilder = new PageBuilder(TYPES);
        }

        public OperatorContext getOperatorContext() {
            return this.operatorContext;
        }

        public List<Type> getTypes() {
            return TYPES;
        }

        public void finish() {
            this.finishing = true;
        }

        public boolean isFinished() {
            return this.finishing && this.pageBuilder.isEmpty();
        }

        public boolean needsInput() {
            return !this.pageBuilder.isFull();
        }

        public void addInput(Page page) {
            Preconditions.checkNotNull((Object)page, (Object)"page is null");
            Preconditions.checkState((!this.pageBuilder.isFull() ? 1 : 0) != 0, (Object)"Output buffer is full");
            Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is finished");
            TpchQuery1Operator.filterAndProjectRowOriented(this.pageBuilder, page.getBlock(0), page.getBlock(1), page.getBlock(2), page.getBlock(3), page.getBlock(4), page.getBlock(5), page.getBlock(6));
        }

        public Page getOutput() {
            if (this.pageBuilder.isFull() || this.finishing && !this.pageBuilder.isEmpty()) {
                Page page = this.pageBuilder.build();
                this.pageBuilder.reset();
                return page;
            }
            return null;
        }

        private static void filterAndProjectRowOriented(PageBuilder pageBuilder, Block returnFlagBlock, Block lineStatusBlock, Block quantityBlock, Block extendedPriceBlock, Block discountBlock, Block taxBlock, Block shipDateBlock) {
            int rows = returnFlagBlock.getPositionCount();
            for (int position = 0; position < rows; ++position) {
                int shipDate;
                if (shipDateBlock.isNull(position) || (shipDate = (int)DateType.DATE.getLong(shipDateBlock, position)) > MAX_SHIP_DATE) continue;
                pageBuilder.declarePosition();
                if (returnFlagBlock.isNull(position)) {
                    pageBuilder.getBlockBuilder(0).appendNull();
                } else {
                    VarcharType.VARCHAR.appendTo(returnFlagBlock, position, pageBuilder.getBlockBuilder(0));
                }
                if (lineStatusBlock.isNull(position)) {
                    pageBuilder.getBlockBuilder(1).appendNull();
                } else {
                    VarcharType.VARCHAR.appendTo(lineStatusBlock, position, pageBuilder.getBlockBuilder(1));
                }
                long quantity = BigintType.BIGINT.getLong(quantityBlock, position);
                double extendedPrice = DoubleType.DOUBLE.getDouble(extendedPriceBlock, position);
                double discount = DoubleType.DOUBLE.getDouble(discountBlock, position);
                double tax = DoubleType.DOUBLE.getDouble(taxBlock, position);
                boolean quantityIsNull = quantityBlock.isNull(position);
                boolean extendedPriceIsNull = extendedPriceBlock.isNull(position);
                boolean discountIsNull = discountBlock.isNull(position);
                boolean taxIsNull = taxBlock.isNull(position);
                if (quantityIsNull) {
                    pageBuilder.getBlockBuilder(2).appendNull();
                } else {
                    BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(2), quantity);
                }
                if (extendedPriceIsNull) {
                    pageBuilder.getBlockBuilder(3).appendNull();
                } else {
                    DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(3), extendedPrice);
                }
                if (extendedPriceIsNull || discountIsNull) {
                    pageBuilder.getBlockBuilder(4).appendNull();
                } else {
                    DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(4), extendedPrice * (1.0 - discount));
                }
                if (extendedPriceIsNull || discountIsNull || taxIsNull) {
                    pageBuilder.getBlockBuilder(5).appendNull();
                } else {
                    DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(5), extendedPrice * (1.0 - discount) * (1.0 + tax));
                }
                if (discountIsNull) {
                    pageBuilder.getBlockBuilder(6).appendNull();
                    continue;
                }
                DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(6), discount);
            }
        }

        public static class TpchQuery1OperatorFactory
        implements OperatorFactory {
            private final int operatorId;

            public TpchQuery1OperatorFactory(int operatorId) {
                this.operatorId = operatorId;
            }

            public List<Type> getTypes() {
                return TYPES;
            }

            public Operator createOperator(DriverContext driverContext) {
                OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, TpchQuery1Operator.class.getSimpleName());
                return new TpchQuery1Operator(operatorContext);
            }

            public void close() {
            }
        }
    }
}

