/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.BenchmarkResultHook;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class JsonBenchmarkResultWriter
implements BenchmarkResultHook {
    private final JsonGenerator jsonGenerator;

    public JsonBenchmarkResultWriter(OutputStream outputStream) {
        Preconditions.checkNotNull((Object)outputStream, (Object)"outputStream is null");
        try {
            this.jsonGenerator = new JsonFactory().createJsonGenerator(outputStream, JsonEncoding.UTF8);
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeArrayFieldStart("samples");
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public BenchmarkResultHook addResults(Map<String, Long> results) {
        Preconditions.checkNotNull(results, (Object)"results is null");
        try {
            this.jsonGenerator.writeStartObject();
            for (Map.Entry<String, Long> entry : results.entrySet()) {
                this.jsonGenerator.writeNumberField(entry.getKey(), entry.getValue().longValue());
            }
            this.jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return this;
    }

    @Override
    public void finished() {
        try {
            this.jsonGenerator.writeEndArray();
            this.jsonGenerator.writeEndObject();
            this.jsonGenerator.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

