/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractOperatorBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.NullOutputOperator;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.List;

public class HashBuildAndJoinBenchmark
extends AbstractOperatorBenchmark {
    public HashBuildAndJoinBenchmark(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hash_build_and_join", 4, 5);
    }

    @Override
    protected List<Driver> createDrivers(TaskContext taskContext) {
        OperatorFactory ordersTableScan = this.createTableScanOperator(0, "orders", "orderkey", "totalprice");
        HashBuilderOperator.HashBuilderOperatorFactory hashBuilder = new HashBuilderOperator.HashBuilderOperatorFactory(1, ordersTableScan.getTypes(), Ints.asList((int[])new int[]{0}), 1500000);
        DriverFactory hashBuildDriverFactory = new DriverFactory(true, false, ordersTableScan, new OperatorFactory[]{hashBuilder});
        Driver hashBuildDriver = hashBuildDriverFactory.createDriver(taskContext.addPipelineContext(true, false).addDriverContext());
        OperatorFactory lineItemTableScan = this.createTableScanOperator(0, "lineitem", "orderkey", "quantity");
        OperatorFactory joinOperator = LookupJoinOperators.innerJoin((int)1, (LookupSourceSupplier)hashBuilder.getLookupSourceSupplier(), (List)lineItemTableScan.getTypes(), (List)Ints.asList((int[])new int[]{0}));
        NullOutputOperator.NullOutputOperatorFactory output = new NullOutputOperator.NullOutputOperatorFactory(2, joinOperator.getTypes());
        DriverFactory joinDriverFactory = new DriverFactory(true, true, lineItemTableScan, new OperatorFactory[]{joinOperator, output});
        Driver joinDriver = joinDriverFactory.createDriver(taskContext.addPipelineContext(true, true).addDriverContext());
        return ImmutableList.of((Object)hashBuildDriver, (Object)joinDriver);
    }

    public static void main(String[] args) {
        new HashBuildAndJoinBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

