/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractBenchmark;
import com.facebook.presto.benchmark.BenchmarkResultHook;
import com.facebook.presto.benchmark.CountAggregationBenchmark;
import com.facebook.presto.benchmark.CountAggregationSqlBenchmark;
import com.facebook.presto.benchmark.CountWithFilterSqlBenchmark;
import com.facebook.presto.benchmark.DoubleSumAggregationBenchmark;
import com.facebook.presto.benchmark.GroupByAggregationSqlBenchmark;
import com.facebook.presto.benchmark.GroupBySumWithArithmeticSqlBenchmark;
import com.facebook.presto.benchmark.HandTpchQuery1;
import com.facebook.presto.benchmark.HandTpchQuery6;
import com.facebook.presto.benchmark.HashAggregationBenchmark;
import com.facebook.presto.benchmark.HashBuildAndJoinBenchmark;
import com.facebook.presto.benchmark.HashBuildBenchmark;
import com.facebook.presto.benchmark.HashJoinBenchmark;
import com.facebook.presto.benchmark.JsonAvgBenchmarkResultWriter;
import com.facebook.presto.benchmark.JsonBenchmarkResultWriter;
import com.facebook.presto.benchmark.OdsBenchmarkResultWriter;
import com.facebook.presto.benchmark.OrderByBenchmark;
import com.facebook.presto.benchmark.PredicateFilterBenchmark;
import com.facebook.presto.benchmark.PredicateFilterSqlBenchmark;
import com.facebook.presto.benchmark.RawStreamingBenchmark;
import com.facebook.presto.benchmark.RawStreamingSqlBenchmark;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.benchmark.SqlApproximateCountDistinctDoubleBenchmark;
import com.facebook.presto.benchmark.SqlApproximateCountDistinctLongBenchmark;
import com.facebook.presto.benchmark.SqlApproximateCountDistinctVarBinaryBenchmark;
import com.facebook.presto.benchmark.SqlApproximatePercentileBenchmark;
import com.facebook.presto.benchmark.SqlBetweenBenchmark;
import com.facebook.presto.benchmark.SqlDistinctMultipleFields;
import com.facebook.presto.benchmark.SqlDistinctSingleField;
import com.facebook.presto.benchmark.SqlDoubleSumAggregationBenchmark;
import com.facebook.presto.benchmark.SqlHashJoinBenchmark;
import com.facebook.presto.benchmark.SqlInBenchmark;
import com.facebook.presto.benchmark.SqlJoinWithPredicateBenchmark;
import com.facebook.presto.benchmark.SqlLikeBenchmark;
import com.facebook.presto.benchmark.SqlRegexpLikeBenchmark;
import com.facebook.presto.benchmark.SqlSemiJoinInPredicateBenchmark;
import com.facebook.presto.benchmark.SqlTpchQuery1;
import com.facebook.presto.benchmark.SqlTpchQuery6;
import com.facebook.presto.benchmark.StatisticsBenchmark;
import com.facebook.presto.benchmark.Top100Benchmark;
import com.facebook.presto.benchmark.Top100SqlBenchmark;
import com.facebook.presto.benchmark.VarBinaryMaxAggregationSqlBenchmark;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import io.airlift.log.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class BenchmarkSuite {
    private static final Logger LOGGER = Logger.get(BenchmarkSuite.class);
    private final LocalQueryRunner localQueryRunner;
    private final String outputDirectory;

    public static List<AbstractBenchmark> createBenchmarks(LocalQueryRunner localQueryRunner) {
        return ImmutableList.of((Object)new CountAggregationBenchmark(localQueryRunner), (Object)new DoubleSumAggregationBenchmark(localQueryRunner), (Object)new HashAggregationBenchmark(localQueryRunner), (Object)new PredicateFilterBenchmark(localQueryRunner), (Object)new RawStreamingBenchmark(localQueryRunner), (Object)new Top100Benchmark(localQueryRunner), (Object)new OrderByBenchmark(localQueryRunner), (Object)new HashBuildBenchmark(localQueryRunner), (Object)new HashJoinBenchmark(localQueryRunner), (Object)new HashBuildAndJoinBenchmark(localQueryRunner), (Object)new HandTpchQuery1(localQueryRunner), (Object)new HandTpchQuery6(localQueryRunner), (Object[])new AbstractBenchmark[]{new GroupBySumWithArithmeticSqlBenchmark(localQueryRunner), new CountAggregationSqlBenchmark(localQueryRunner), new SqlDoubleSumAggregationBenchmark(localQueryRunner), new CountWithFilterSqlBenchmark(localQueryRunner), new GroupByAggregationSqlBenchmark(localQueryRunner), new PredicateFilterSqlBenchmark(localQueryRunner), new RawStreamingSqlBenchmark(localQueryRunner), new Top100SqlBenchmark(localQueryRunner), new SqlHashJoinBenchmark(localQueryRunner), new SqlJoinWithPredicateBenchmark(localQueryRunner), new VarBinaryMaxAggregationSqlBenchmark(localQueryRunner), new SqlDistinctMultipleFields(localQueryRunner), new SqlDistinctSingleField(localQueryRunner), new SqlTpchQuery1(localQueryRunner), new SqlTpchQuery6(localQueryRunner), new SqlLikeBenchmark(localQueryRunner), new SqlInBenchmark(localQueryRunner), new SqlSemiJoinInPredicateBenchmark(localQueryRunner), new SqlRegexpLikeBenchmark(localQueryRunner), new SqlApproximatePercentileBenchmark(localQueryRunner), new SqlBetweenBenchmark(localQueryRunner), new StatisticsBenchmark.LongVarianceBenchmark(localQueryRunner), new StatisticsBenchmark.LongVariancePopBenchmark(localQueryRunner), new StatisticsBenchmark.DoubleVarianceBenchmark(localQueryRunner), new StatisticsBenchmark.DoubleVariancePopBenchmark(localQueryRunner), new StatisticsBenchmark.LongStdDevBenchmark(localQueryRunner), new StatisticsBenchmark.LongStdDevPopBenchmark(localQueryRunner), new StatisticsBenchmark.DoubleStdDevBenchmark(localQueryRunner), new StatisticsBenchmark.DoubleStdDevPopBenchmark(localQueryRunner), new SqlApproximateCountDistinctLongBenchmark(localQueryRunner), new SqlApproximateCountDistinctDoubleBenchmark(localQueryRunner), new SqlApproximateCountDistinctVarBinaryBenchmark(localQueryRunner)});
    }

    public BenchmarkSuite(LocalQueryRunner localQueryRunner, String outputDirectory) {
        this.localQueryRunner = localQueryRunner;
        this.outputDirectory = (String)Preconditions.checkNotNull((Object)outputDirectory, (Object)"outputDirectory is null");
    }

    private static File createOutputFile(String fileName) throws IOException {
        File outputFile = new File(fileName);
        Files.createParentDirs((File)outputFile);
        return outputFile;
    }

    public void runAllBenchmarks() throws IOException {
        List<AbstractBenchmark> benchmarks = BenchmarkSuite.createBenchmarks(this.localQueryRunner);
        LOGGER.info("=== Pre-running all benchmarks for JVM warmup ===");
        for (AbstractBenchmark benchmark : benchmarks) {
            benchmark.runBenchmark();
        }
        LOGGER.info("=== Actually running benchmarks for metrics ===");
        for (AbstractBenchmark benchmark : benchmarks) {
            FileOutputStream jsonOut = new FileOutputStream(BenchmarkSuite.createOutputFile(String.format("%s/json/%s.json", this.outputDirectory, benchmark.getBenchmarkName())));
            Throwable throwable = null;
            try {
                FileOutputStream jsonAvgOut = new FileOutputStream(BenchmarkSuite.createOutputFile(String.format("%s/json-avg/%s.json", this.outputDirectory, benchmark.getBenchmarkName())));
                Throwable throwable2 = null;
                try {
                    FileOutputStream csvOut = new FileOutputStream(BenchmarkSuite.createOutputFile(String.format("%s/csv/%s.csv", this.outputDirectory, benchmark.getBenchmarkName())));
                    Throwable throwable3 = null;
                    try {
                        FileOutputStream odsOut = new FileOutputStream(BenchmarkSuite.createOutputFile(String.format("%s/ods/%s.json", this.outputDirectory, benchmark.getBenchmarkName())));
                        Throwable throwable4 = null;
                        try {
                            benchmark.runBenchmark(new ForwardingBenchmarkResultWriter((List)ImmutableList.of((Object)new JsonBenchmarkResultWriter(jsonOut), (Object)new JsonAvgBenchmarkResultWriter(jsonAvgOut), (Object)new SimpleLineBenchmarkResultWriter(csvOut), (Object)new OdsBenchmarkResultWriter("presto.benchmark." + benchmark.getBenchmarkName(), odsOut))));
                        }
                        catch (Throwable throwable5) {
                            throwable4 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (odsOut == null) continue;
                            if (throwable4 != null) {
                                try {
                                    ((OutputStream)odsOut).close();
                                }
                                catch (Throwable x2) {
                                    throwable4.addSuppressed(x2);
                                }
                                continue;
                            }
                            ((OutputStream)odsOut).close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable3 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (csvOut == null) continue;
                        if (throwable3 != null) {
                            try {
                                ((OutputStream)csvOut).close();
                            }
                            catch (Throwable x2) {
                                throwable3.addSuppressed(x2);
                            }
                            continue;
                        }
                        ((OutputStream)csvOut).close();
                    }
                }
                catch (Throwable throwable7) {
                    throwable2 = throwable7;
                    throw throwable7;
                }
                finally {
                    if (jsonAvgOut == null) continue;
                    if (throwable2 != null) {
                        try {
                            ((OutputStream)jsonAvgOut).close();
                        }
                        catch (Throwable x2) {
                            throwable2.addSuppressed(x2);
                        }
                        continue;
                    }
                    ((OutputStream)jsonAvgOut).close();
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (jsonOut == null) continue;
                if (throwable != null) {
                    try {
                        ((OutputStream)jsonOut).close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                ((OutputStream)jsonOut).close();
            }
        }
    }

    private static class ForwardingBenchmarkResultWriter
    implements BenchmarkResultHook {
        private final List<BenchmarkResultHook> benchmarkResultHooks;

        private ForwardingBenchmarkResultWriter(List<BenchmarkResultHook> benchmarkResultHooks) {
            Preconditions.checkNotNull(benchmarkResultHooks, (Object)"benchmarkResultWriters is null");
            this.benchmarkResultHooks = ImmutableList.copyOf(benchmarkResultHooks);
        }

        @Override
        public BenchmarkResultHook addResults(Map<String, Long> results) {
            Preconditions.checkNotNull(results, (Object)"results is null");
            for (BenchmarkResultHook benchmarkResultHook : this.benchmarkResultHooks) {
                benchmarkResultHook.addResults(results);
            }
            return this;
        }

        @Override
        public void finished() {
            for (BenchmarkResultHook benchmarkResultHook : this.benchmarkResultHooks) {
                benchmarkResultHook.finished();
            }
        }
    }
}

