/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.benchmark.AbstractSqlBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.intellij.lang.annotations.Language;

public class SqlRewriteConditionalAggregationBenchmarks
extends AbstractSqlBenchmark {
    private static final Logger LOGGER = Logger.get(SqlRewriteConditionalAggregationBenchmarks.class);

    public SqlRewriteConditionalAggregationBenchmarks(LocalQueryRunner localQueryRunner, @Language(value="SQL") String sql) {
        super(localQueryRunner, "sql_rewrite_conditional_aggregation", 5, 10, sql);
    }

    public static void main(String[] args) {
        ImmutableMap enableOptimization = ImmutableMap.of((Object)"optimize_conditional_aggregation_enabled", (Object)"true");
        LOGGER.info("SQL query with more grouping sets");
        String sqlWithCube = "SELECT IF(GROUPING(suppkey, orderkey, partkey) = FROM_BASE('011', 2), APPROX_DISTINCT(tax)), IF(GROUPING(suppkey, orderkey, partkey) = FROM_BASE('011', 2), APPROX_DISTINCT(extendedprice)), IF(GROUPING(suppkey, orderkey, partkey) = FROM_BASE('011', 2), APPROX_DISTINCT(discount)) FROM lineitem GROUP BY CUBE(suppkey, orderkey, partkey)";
        LOGGER.info("Without optimization");
        new SqlRewriteConditionalAggregationBenchmarks(BenchmarkQueryRunner.createLocalQueryRunner(), sqlWithCube).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        LOGGER.info("With optimization");
        new SqlRewriteConditionalAggregationBenchmarks(BenchmarkQueryRunner.createLocalQueryRunner((Map<String, String>)enableOptimization), sqlWithCube).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        LOGGER.info("SQL query with fewer grouping sets");
        String sqlNoCube = "SELECT IF(GROUPING(suppkey, orderkey, partkey) = FROM_BASE('011', 2), APPROX_DISTINCT(tax)), IF(GROUPING(suppkey, orderkey, partkey) = FROM_BASE('101', 2), APPROX_DISTINCT(extendedprice)), IF(GROUPING(suppkey, orderkey, partkey) = FROM_BASE('110', 2), APPROX_DISTINCT(discount)) FROM lineitem GROUP BY GROUPING SETS ((suppkey), (orderkey), (partkey))";
        LOGGER.info("Without optimization");
        new SqlRewriteConditionalAggregationBenchmarks(BenchmarkQueryRunner.createLocalQueryRunner(), sqlNoCube).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        LOGGER.info("With optimization");
        new SqlRewriteConditionalAggregationBenchmarks(BenchmarkQueryRunner.createLocalQueryRunner((Map<String, String>)enableOptimization), sqlNoCube).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        LOGGER.info("SQL query with cheaper aggregation functions");
        String sqlWithSum = "SELECT IF(GROUPING(suppkey, orderkey, partkey) = FROM_BASE('011', 2), SUM(tax)), IF(GROUPING(suppkey, orderkey, partkey) = FROM_BASE('011', 2), SUM(extendedprice)), IF(GROUPING(suppkey, orderkey, partkey) = FROM_BASE('011', 2), SUM(discount)) FROM lineitem GROUP BY CUBE(suppkey, orderkey, partkey)";
        LOGGER.info("Without optimization");
        new SqlRewriteConditionalAggregationBenchmarks(BenchmarkQueryRunner.createLocalQueryRunner(), sqlWithSum).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        LOGGER.info("With optimization");
        new SqlRewriteConditionalAggregationBenchmarks(BenchmarkQueryRunner.createLocalQueryRunner((Map<String, String>)enableOptimization), sqlWithSum).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

