/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractOperatorBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.JoinBridgeManager;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PartitionedLookupSourceFactory;
import com.facebook.presto.operator.PipelineExecutionStrategy;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.ValuesOperator;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spiller.PartitioningSpillerFactory;
import com.facebook.presto.spiller.SingleStreamSpillerFactory;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.NullOutputOperator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class HashBuildBenchmark
extends AbstractOperatorBenchmark {
    private static final LookupJoinOperators LOOKUP_JOIN_OPERATORS = new LookupJoinOperators();

    public HashBuildBenchmark(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hash_build", 4, 5);
    }

    @Override
    protected List<Driver> createDrivers(TaskContext taskContext) {
        List<Type> ordersTypes = this.getColumnTypes("orders", "orderkey", "totalprice");
        OperatorFactory ordersTableScan = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "orderkey", "totalprice");
        JoinBridgeManager lookupSourceFactoryManager = JoinBridgeManager.lookupAllAtOnce((PartitionedLookupSourceFactory)new PartitionedLookupSourceFactory(ordersTypes, (List)ImmutableList.of((Object)0, (Object)1).stream().map(ordersTypes::get).collect(ImmutableList.toImmutableList()), (List)Ints.asList((int[])new int[]{0}).stream().map(ordersTypes::get).collect(ImmutableList.toImmutableList()), 1, (Map)Objects.requireNonNull(ImmutableMap.of(), "layout is null"), false));
        HashBuilderOperator.HashBuilderOperatorFactory hashBuilder = new HashBuilderOperator.HashBuilderOperatorFactory(1, new PlanNodeId("test"), lookupSourceFactoryManager, (List)ImmutableList.of((Object)0, (Object)1), Ints.asList((int[])new int[]{0}), OptionalInt.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), 1500000, (PagesIndex.Factory)new PagesIndex.TestingFactory(false), false, SingleStreamSpillerFactory.unsupportedSingleStreamSpillerFactory(), false);
        DriverFactory hashBuildDriverFactory = new DriverFactory(0, true, true, (List)ImmutableList.of((Object)ordersTableScan, (Object)hashBuilder), OptionalInt.empty(), PipelineExecutionStrategy.UNGROUPED_EXECUTION, Optional.empty());
        ImmutableList.Builder joinDriversBuilder = ImmutableList.builder();
        joinDriversBuilder.add((Object)new ValuesOperator.ValuesOperatorFactory(0, new PlanNodeId("values"), (List)ImmutableList.of()));
        OperatorFactory joinOperator = LOOKUP_JOIN_OPERATORS.innerJoin(2, new PlanNodeId("test"), lookupSourceFactoryManager, (List)ImmutableList.of((Object)BigintType.BIGINT), Ints.asList((int[])new int[]{0}), OptionalInt.empty(), Optional.empty(), OptionalInt.empty(), PartitioningSpillerFactory.unsupportedPartitioningSpillerFactory(), false);
        joinDriversBuilder.add((Object)joinOperator);
        joinDriversBuilder.add((Object)new NullOutputOperator.NullOutputOperatorFactory(3, new PlanNodeId("test")));
        DriverFactory joinDriverFactory = new DriverFactory(1, true, true, (List)joinDriversBuilder.build(), OptionalInt.empty(), PipelineExecutionStrategy.UNGROUPED_EXECUTION, Optional.empty());
        Driver hashBuildDriver = hashBuildDriverFactory.createDriver(taskContext.addPipelineContext(0, true, true, false).addDriverContext());
        hashBuildDriverFactory.noMoreDrivers();
        Driver joinDriver = joinDriverFactory.createDriver(taskContext.addPipelineContext(1, true, true, false).addDriverContext());
        joinDriverFactory.noMoreDrivers();
        return ImmutableList.of((Object)hashBuildDriver, (Object)joinDriver);
    }

    public static void main(String[] args) {
        new HashBuildBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

