/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.benchmark.AbstractSqlBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.benchmark.SqlRewriteConditionalAggregationBenchmarks;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.intellij.lang.annotations.Language;

public class SqlPullConstantsAboveGroupByBenchmark
extends AbstractSqlBenchmark {
    private static final Logger LOGGER = Logger.get(SqlRewriteConditionalAggregationBenchmarks.class);

    public SqlPullConstantsAboveGroupByBenchmark(LocalQueryRunner localQueryRunner, @Language(value="SQL") String sql) {
        super(localQueryRunner, "pull_constants_above_group_by", 10, 20, sql);
    }

    public static void main(String[] args) {
        ImmutableMap disableOptimization = ImmutableMap.of((Object)"optimize_constant_grouping_keys", (Object)"false");
        String sql = "SELECT * FROM (SELECT regionkey, col, count(*) FROM (SELECT regionkey, 'bla' as col FROM nation) GROUP BY regionkey, col)";
        LOGGER.info("Without optimization");
        new SqlPullConstantsAboveGroupByBenchmark(BenchmarkQueryRunner.createLocalQueryRunner((Map<String, String>)disableOptimization), sql).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        LOGGER.info("With optimization");
        new SqlPullConstantsAboveGroupByBenchmark(BenchmarkQueryRunner.createLocalQueryRunner(), sql).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

