/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractSqlBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;

public final class SqlMultipleApproxPercentileBenchmarks {
    private SqlMultipleApproxPercentileBenchmarks() {
    }

    public static String getSql(int approxPercentileNumber) {
        ArrayList<String> list = new ArrayList<String>();
        double increment = 1.0 / (double)(approxPercentileNumber + 1);
        for (int i = 0; i < approxPercentileNumber; ++i) {
            list.add(String.format(" approx_percentile(extendedprice, %f)", (double)(i + 1) * increment));
        }
        String sql = String.format("select %s from lineitem", String.join((CharSequence)", ", list));
        return sql;
    }

    public static void main(String[] args) {
        for (int i = 1; i < 20; ++i) {
            System.out.println(String.format("%d approx_percentile functions", i));
            System.out.println("Without optimization");
            new SqlMultipleApproxPercentileBenchmark(BenchmarkQueryRunner.createLocalQueryRunner((Map<String, String>)ImmutableMap.of((Object)"optimize_multiple_approx_percentile_on_same_field", (Object)"false")), SqlMultipleApproxPercentileBenchmarks.getSql(i)).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
            System.out.println("With optimization");
            new SqlMultipleApproxPercentileBenchmark(BenchmarkQueryRunner.createLocalQueryRunner(), SqlMultipleApproxPercentileBenchmarks.getSql(i)).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        }
    }

    public static class SqlMultipleApproxPercentileBenchmark
    extends AbstractSqlBenchmark {
        public SqlMultipleApproxPercentileBenchmark(LocalQueryRunner localQueryRunner, String sql) {
            super(localQueryRunner, "sql_multiple_approx_percentile", 10, 30, sql);
        }
    }
}

