/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.benchmark.AbstractSqlBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.intellij.lang.annotations.Language;

public class SqlEarlyOutJoinsBenchmarks
extends AbstractSqlBenchmark {
    private static final Logger LOGGER = Logger.get(SqlEarlyOutJoinsBenchmarks.class);
    private static Map<String, String> disableOptimization = ImmutableMap.of((Object)"in_predicates_as_inner_joins_enabled", (Object)Boolean.toString(false), (Object)"exploit_constraints", (Object)Boolean.toString(true));
    private static Map<String, String> enableOptimization = ImmutableMap.of((Object)"in_predicates_as_inner_joins_enabled", (Object)Boolean.toString(true), (Object)"exploit_constraints", (Object)Boolean.toString(true));

    public SqlEarlyOutJoinsBenchmarks(LocalQueryRunner localQueryRunner, @Language(value="SQL") String sql) {
        super(localQueryRunner, "early_out_joins", 10, 10, sql);
    }

    public static void main(String[] args) {
        SqlEarlyOutJoinsBenchmarks.benchmarkTransformDistinctInnerJoinToLeftEarlyOutJoin();
        SqlEarlyOutJoinsBenchmarks.benchmarkTransformDistinctInnerJoinToRightEarlyOutJoin();
        SqlEarlyOutJoinsBenchmarks.benchmarkRewriteOfInPredicateToDistinctInnerJoin();
    }

    private static void benchmarkTransformDistinctInnerJoinToLeftEarlyOutJoin() {
        LOGGER.info("benchmarkTransformDistinctInnerJoinToLeftEarlyOutJoin");
        String sql = "select distinct orderkey from lineitem, nation where orderkey=nationkey";
        LOGGER.info("Without optimization");
        new SqlEarlyOutJoinsBenchmarks(BenchmarkQueryRunner.createLocalQueryRunner(disableOptimization), sql).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        LOGGER.info("With optimization");
        new SqlEarlyOutJoinsBenchmarks(BenchmarkQueryRunner.createLocalQueryRunner(enableOptimization), sql).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }

    private static void benchmarkTransformDistinctInnerJoinToRightEarlyOutJoin() {
        LOGGER.info("benchmarkTransformDistinctInnerJoinToRightEarlyOutJoin");
        String sql = "select distinct l.orderkey, l.comment from lineitem l, orders o where l.orderkey = o.orderkey";
        LOGGER.info("Without optimization");
        new SqlEarlyOutJoinsBenchmarks(BenchmarkQueryRunner.createLocalQueryRunner(disableOptimization), sql).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        LOGGER.info("With optimization");
        new SqlEarlyOutJoinsBenchmarks(BenchmarkQueryRunner.createLocalQueryRunner(enableOptimization), sql).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }

    private static void benchmarkRewriteOfInPredicateToDistinctInnerJoin() {
        LOGGER.info("benchmarkInPredicateToDistinctInnerJoin");
        LOGGER.info("Case 1: Rewrite IN predicate to distinct + inner join");
        String sql = " explain select * from region where regionkey in (select orderkey from lineitem)";
        LOGGER.info("Without optimization");
        new SqlEarlyOutJoinsBenchmarks(BenchmarkQueryRunner.createLocalQueryRunner(disableOptimization), sql).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        LOGGER.info("With optimization: case 1");
        new SqlEarlyOutJoinsBenchmarks(BenchmarkQueryRunner.createLocalQueryRunner(enableOptimization), sql).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        LOGGER.info("Case 2: Rewrite IN predicate to distinct + inner join and then push aggregation down into the probe of the join");
        LOGGER.info("With optimization: case 2");
        ImmutableMap alteredByteReductionThreshold = ImmutableMap.builder().putAll(enableOptimization).put((Object)"push_aggregation_below_join_byte_reduction_threshold", (Object)"0.001").build();
        new SqlEarlyOutJoinsBenchmarks(BenchmarkQueryRunner.createLocalQueryRunner(enableOptimization), sql).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

