/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractSqlBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public abstract class AggregateIfBenchmark {
    public static void main(String ... args) {
        LocalQueryRunner localQueryRunnerWithRewrite = BenchmarkQueryRunner.createLocalQueryRunner((Map<String, String>)ImmutableMap.of((Object)"aggregation_if_to_filter_rewrite_strategy", (Object)"filter_with_if"));
        LocalQueryRunner localQueryRunnerWithoutRewrite = BenchmarkQueryRunner.createLocalQueryRunner((Map<String, String>)ImmutableMap.of((Object)"aggregation_if_to_filter_rewrite_strategy", (Object)"disabled"));
        new SumIfBenchmark(localQueryRunnerWithoutRewrite, false).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        new SumIfBenchmark(localQueryRunnerWithRewrite, true).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        new SumFilterBenchmark(localQueryRunnerWithRewrite).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }

    public static class SumFilterBenchmark
    extends AbstractSqlBenchmark {
        public SumFilterBenchmark(LocalQueryRunner localQueryRunner) {
            super(localQueryRunner, "sum_filter", 5, 50, "SELECT SUM(orderkey) FILTER(WHERE orderstatus = 'F') FROM tpch.sf1.orders");
        }
    }

    public static class SumIfBenchmark
    extends AbstractSqlBenchmark {
        public SumIfBenchmark(LocalQueryRunner localQueryRunner, boolean enableRewrite) {
            super(localQueryRunner, "sum_if_" + (enableRewrite ? "with_rewrite" : "without_rewrite"), 5, 50, "SELECT SUM(IF(orderstatus = 'F', orderkey)) FROM tpch.sf1.orders");
        }
    }
}

