/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractSimpleOperatorBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.operator.HashAggregationOperator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Optional;

public class HashAggregationBenchmark
extends AbstractSimpleOperatorBenchmark {
    private final InternalAggregationFunction doubleSum;

    public HashAggregationBenchmark(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hash_agg", 5, 25);
        FunctionManager functionManager = localQueryRunner.getMetadata().getFunctionManager();
        this.doubleSum = functionManager.getAggregateFunctionImplementation(functionManager.lookupFunction("sum", TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE})));
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        List<Type> tableTypes = this.getColumnTypes("orders", "orderstatus", "totalprice");
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "orderstatus", "totalprice");
        HashAggregationOperator.HashAggregationOperatorFactory aggregationOperator = new HashAggregationOperator.HashAggregationOperatorFactory(1, new PlanNodeId("test"), (List)ImmutableList.of((Object)tableTypes.get(0)), Ints.asList((int[])new int[]{0}), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)this.doubleSum.bind((List)ImmutableList.of((Object)1), Optional.empty())), Optional.empty(), Optional.empty(), 100000, Optional.of(new DataSize(16.0, DataSize.Unit.MEGABYTE)), JOIN_COMPILER, false);
        return ImmutableList.of((Object)tableScanOperator, (Object)aggregationOperator);
    }

    public static void main(String[] args) {
        new HashAggregationBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

