/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.stats.CpuTimer;
import com.facebook.airlift.stats.GcMonitor;
import com.facebook.airlift.stats.TestingGcMonitor;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.benchmark.AbstractBenchmark;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PageSourceOperator;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.operator.project.InputPageProjection;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.PageProjectionWithOutputs;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AllowAllAccessControl;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spiller.SpillSpaceTracker;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.planner.optimizations.HashGenerationOptimizer;
import com.facebook.presto.sql.relational.VariableToChannelTranslator;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.TransactionId;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class AbstractOperatorBenchmark
extends AbstractBenchmark {
    protected final LocalQueryRunner localQueryRunner;
    protected final Session session;

    protected AbstractOperatorBenchmark(LocalQueryRunner localQueryRunner, String benchmarkName, int warmupIterations, int measuredIterations) {
        this(localQueryRunner.getDefaultSession(), localQueryRunner, benchmarkName, warmupIterations, measuredIterations);
    }

    protected AbstractOperatorBenchmark(Session session, LocalQueryRunner localQueryRunner, String benchmarkName, int warmupIterations, int measuredIterations) {
        super(benchmarkName, warmupIterations, measuredIterations);
        this.localQueryRunner = Objects.requireNonNull(localQueryRunner, "localQueryRunner is null");
        TransactionId transactionId = localQueryRunner.getTransactionManager().beginTransaction(false);
        this.session = session.beginTransactionId(transactionId, localQueryRunner.getTransactionManager(), (AccessControl)new AllowAllAccessControl());
    }

    @Override
    protected void tearDown() {
        this.localQueryRunner.getTransactionManager().asyncAbort(this.session.getRequiredTransactionId());
        super.tearDown();
    }

    protected final List<Type> getColumnTypes(String tableName, String ... columnNames) {
        Preconditions.checkState((boolean)this.session.getCatalog().isPresent(), (Object)"catalog not set");
        Preconditions.checkState((boolean)this.session.getSchema().isPresent(), (Object)"schema not set");
        Metadata metadata = this.localQueryRunner.getMetadata();
        QualifiedObjectName qualifiedTableName = new QualifiedObjectName((String)this.session.getCatalog().get(), (String)this.session.getSchema().get(), tableName);
        TableHandle tableHandle = (TableHandle)metadata.getTableHandle(this.session, qualifiedTableName).orElseThrow(() -> new IllegalArgumentException(String.format("Table %s does not exist", qualifiedTableName)));
        Map allColumnHandles = metadata.getColumnHandles(this.session, tableHandle);
        return (List)Arrays.stream(columnNames).map(allColumnHandles::get).map(columnHandle -> metadata.getColumnMetadata(this.session, tableHandle, columnHandle).getType()).collect(ImmutableList.toImmutableList());
    }

    protected final OperatorFactory createTableScanOperator(final int operatorId, final PlanNodeId planNodeId, String tableName, String ... columnNames) {
        Preconditions.checkArgument((boolean)this.session.getCatalog().isPresent(), (Object)"catalog not set");
        Preconditions.checkArgument((boolean)this.session.getSchema().isPresent(), (Object)"schema not set");
        Metadata metadata = this.localQueryRunner.getMetadata();
        QualifiedObjectName qualifiedTableName = new QualifiedObjectName((String)this.session.getCatalog().get(), (String)this.session.getSchema().get(), tableName);
        final TableHandle tableHandle = metadata.getTableHandle(this.session, qualifiedTableName).orElse(null);
        Preconditions.checkArgument((tableHandle != null ? 1 : 0) != 0, (String)"Table %s does not exist", (Object)qualifiedTableName);
        Map allColumnHandles = metadata.getColumnHandles(this.session, tableHandle);
        ImmutableList.Builder columnHandlesBuilder = ImmutableList.builder();
        for (String columnName : columnNames) {
            ColumnHandle columnHandle = (ColumnHandle)allColumnHandles.get(columnName);
            Preconditions.checkArgument((columnHandle != null ? 1 : 0) != 0, (String)"Table %s does not have a column %s", (Object)tableName, (Object)columnName);
            columnHandlesBuilder.add((Object)columnHandle);
        }
        ImmutableList columnHandles = columnHandlesBuilder.build();
        final Split split = this.getLocalQuerySplit(this.session, tableHandle);
        return new OperatorFactory((List)columnHandles){
            final /* synthetic */ List val$columnHandles;
            {
                this.val$columnHandles = list;
            }

            public Operator createOperator(DriverContext driverContext) {
                OperatorContext operatorContext = driverContext.addOperatorContext(operatorId, planNodeId, "BenchmarkSource");
                ConnectorPageSource pageSource = AbstractOperatorBenchmark.this.localQueryRunner.getPageSourceManager().createPageSource(AbstractOperatorBenchmark.this.session, split, tableHandle.withDynamicFilter(TupleDomain::all), this.val$columnHandles);
                return new PageSourceOperator(pageSource, operatorContext);
            }

            public void noMoreOperators() {
            }

            public OperatorFactory duplicate() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Split getLocalQuerySplit(Session session, TableHandle handle) {
        SplitSource splitSource = this.localQueryRunner.getSplitManager().getSplits(session, handle, ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING, WarningCollector.NOOP);
        ArrayList<Split> splits = new ArrayList<Split>();
        while (!splitSource.isFinished()) {
            splits.addAll(AbstractOperatorBenchmark.getNextBatch(splitSource));
        }
        Preconditions.checkArgument((splits.size() == 1 ? 1 : 0) != 0, (String)"Expected only one split for a local query, but got %s splits", (int)splits.size());
        return (Split)splits.get(0);
    }

    private static List<Split> getNextBatch(SplitSource splitSource) {
        return ((SplitSource.SplitBatch)MoreFutures.getFutureValue((Future)splitSource.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, Lifespan.taskWide(), 1000))).getSplits();
    }

    protected final OperatorFactory createHashProjectOperator(int operatorId, PlanNodeId planNodeId, List<Type> types) {
        ImmutableList.Builder variables = ImmutableList.builder();
        ImmutableMap.Builder variableToInputMapping = ImmutableMap.builder();
        ImmutableList.Builder projections = ImmutableList.builder();
        for (int channel = 0; channel < types.size(); ++channel) {
            VariableReferenceExpression variable = new VariableReferenceExpression("h" + channel, types.get(channel));
            variables.add((Object)variable);
            variableToInputMapping.put((Object)variable, (Object)channel);
            projections.add((Object)new PageProjectionWithOutputs((PageProjection)new InputPageProjection(channel), new int[]{channel}));
        }
        Optional hashExpression = HashGenerationOptimizer.getHashExpression((FunctionManager)this.localQueryRunner.getMetadata().getFunctionManager(), (List)variables.build());
        Verify.verify((boolean)hashExpression.isPresent());
        RowExpression translatedHashExpression = VariableToChannelTranslator.translate((RowExpression)((RowExpression)hashExpression.get()), (Map)variableToInputMapping.build());
        PageFunctionCompiler functionCompiler = new PageFunctionCompiler(this.localQueryRunner.getMetadata(), 0);
        projections.add((Object)new PageProjectionWithOutputs((PageProjection)functionCompiler.compileProjection(this.session.getSqlFunctionProperties(), translatedHashExpression, Optional.empty()).get(), new int[]{types.size()}));
        return new FilterAndProjectOperator.FilterAndProjectOperatorFactory(operatorId, planNodeId, () -> new PageProcessor(Optional.empty(), (List)projections.build()), (List)ImmutableList.copyOf((Iterable)Iterables.concat(types, (Iterable)ImmutableList.of((Object)BigintType.BIGINT))), SystemSessionProperties.getFilterAndProjectMinOutputPageSize((Session)this.session), SystemSessionProperties.getFilterAndProjectMinOutputPageRowCount((Session)this.session));
    }

    protected abstract List<Driver> createDrivers(TaskContext var1);

    protected Map<String, Long> execute(TaskContext taskContext) {
        List<Driver> drivers = this.createDrivers(taskContext);
        long peakMemory = 0L;
        boolean done = false;
        while (!done) {
            boolean processed = false;
            for (Driver driver : drivers) {
                if (driver.isFinished()) continue;
                driver.process();
                long lastPeakMemory = peakMemory;
                peakMemory = taskContext.getTaskStats().getUserMemoryReservationInBytes();
                if (peakMemory <= lastPeakMemory) {
                    peakMemory = lastPeakMemory;
                }
                processed = true;
            }
            done = !processed;
        }
        return ImmutableMap.of((Object)"peak_memory", (Object)peakMemory);
    }

    @Override
    protected Map<String, Long> runOnce() {
        Session session = TestingSession.testSessionBuilder().setSystemProperty("optimizer.optimize-hash-generation", "true").build();
        MemoryPool memoryPool = new MemoryPool(new MemoryPoolId("test"), new DataSize(1.0, DataSize.Unit.GIGABYTE));
        SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(new DataSize(1.0, DataSize.Unit.GIGABYTE));
        TaskContext taskContext = new QueryContext(new QueryId("test"), new DataSize(256.0, DataSize.Unit.MEGABYTE), new DataSize(512.0, DataSize.Unit.MEGABYTE), new DataSize(256.0, DataSize.Unit.MEGABYTE), memoryPool, (GcMonitor)new TestingGcMonitor(), (Executor)this.localQueryRunner.getExecutor(), this.localQueryRunner.getScheduler(), new DataSize(256.0, DataSize.Unit.MEGABYTE), spillSpaceTracker).addTaskContext(new TaskStateMachine(new TaskId("query", 0, 0, 0), (Executor)this.localQueryRunner.getExecutor()), session, false, false, false, false, false);
        CpuTimer cpuTimer = new CpuTimer();
        Map<String, Long> executionStats = this.execute(taskContext);
        CpuTimer.CpuDuration executionTime = cpuTimer.elapsedTime();
        TaskStats taskStats = taskContext.getTaskStats();
        long inputRows = taskStats.getRawInputPositions();
        long inputBytes = taskStats.getRawInputDataSizeInBytes();
        long outputRows = taskStats.getOutputPositions();
        long outputBytes = taskStats.getOutputDataSizeInBytes();
        double inputMegaBytes = new DataSize((double)inputBytes, DataSize.Unit.BYTE).getValue(DataSize.Unit.MEGABYTE);
        return ImmutableMap.builder().putAll(executionStats).put((Object)"elapsed_millis", (Object)executionTime.getWall().toMillis()).put((Object)"input_rows_per_second", (Object)((long)((double)inputRows / executionTime.getWall().getValue(TimeUnit.SECONDS)))).put((Object)"output_rows_per_second", (Object)((long)((double)outputRows / executionTime.getWall().getValue(TimeUnit.SECONDS)))).put((Object)"input_megabytes", (Object)((long)inputMegaBytes)).put((Object)"input_megabytes_per_second", (Object)((long)(inputMegaBytes / executionTime.getWall().getValue(TimeUnit.SECONDS)))).put((Object)"wall_nanos", (Object)executionTime.getWall().roundTo(TimeUnit.NANOSECONDS)).put((Object)"cpu_nanos", (Object)executionTime.getCpu().roundTo(TimeUnit.NANOSECONDS)).put((Object)"user_nanos", (Object)executionTime.getUser().roundTo(TimeUnit.NANOSECONDS)).put((Object)"input_rows", (Object)inputRows).put((Object)"input_bytes", (Object)inputBytes).put((Object)"output_rows", (Object)outputRows).put((Object)"output_bytes", (Object)outputBytes).build();
    }
}

