/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractSqlBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Map;

public class SqlTopNRowNumberBenchmark
extends AbstractSqlBenchmark {
    public SqlTopNRowNumberBenchmark(LocalQueryRunner localQueryRunner, String function, String partitions, int topN) {
        super(localQueryRunner, String.format("sql_%s_partition_by_(%s)_top_%s", function, partitions, topN), 4, 5, String.format("WITH t AS (  SELECT *, %s() OVER (PARTITION BY %s ORDER BY shipdate DESC) AS rnk  FROM lineitem)SELECT * FROM t WHERE rnk <= %s", function, partitions, topN));
    }

    public static void main(String[] args) {
        LocalQueryRunner localQueryRunner = BenchmarkQueryRunner.createLocalQueryRunner((Map<String, String>)ImmutableMap.of((Object)"resource_overcommit", (Object)"true"));
        for (String function : ImmutableList.of((Object)"row_number", (Object)"rank")) {
            for (String partitions : ImmutableList.of((Object)"orderkey, partkey", (Object)"partkey", (Object)"linestatus")) {
                UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)1, (Object)100, (Object)10000).iterator();
                while (unmodifiableIterator.hasNext()) {
                    int topN = (Integer)unmodifiableIterator.next();
                    new SqlTopNRowNumberBenchmark(localQueryRunner, function, partitions, topN).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
                }
            }
        }
    }
}

