/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.benchmark.AbstractOperatorBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spiller.PartitioningSpillerFactory;
import com.facebook.presto.spiller.SingleStreamSpillerFactory;
import com.facebook.presto.sql.gen.JoinProbeCompiler;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.NullOutputOperator;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

public class HashBuildAndJoinBenchmark
extends AbstractOperatorBenchmark {
    private final boolean hashEnabled;
    private final OperatorFactory ordersTableScan = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "orderkey", "totalprice");
    private final OperatorFactory lineItemTableScan = this.createTableScanOperator(0, new PlanNodeId("test"), "lineitem", "orderkey", "quantity");
    private static final LookupJoinOperators LOOKUP_JOIN_OPERATORS = new LookupJoinOperators(new JoinProbeCompiler());

    public HashBuildAndJoinBenchmark(Session session, LocalQueryRunner localQueryRunner) {
        super(session, localQueryRunner, "hash_build_and_join_hash_enabled_" + HashBuildAndJoinBenchmark.isHashEnabled(session), 4, 5);
        this.hashEnabled = HashBuildAndJoinBenchmark.isHashEnabled(session);
    }

    private static boolean isHashEnabled(Session session) {
        return SystemSessionProperties.isOptimizeHashGenerationEnabled((Session)session);
    }

    @Override
    protected List<Driver> createDrivers(TaskContext taskContext) {
        ImmutableList.Builder driversBuilder = ImmutableList.builder();
        driversBuilder.add((Object)this.ordersTableScan);
        OperatorFactory source = this.ordersTableScan;
        OptionalInt hashChannel = OptionalInt.empty();
        if (this.hashEnabled) {
            source = this.createHashProjectOperator(1, new PlanNodeId("test"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE));
            driversBuilder.add((Object)source);
            hashChannel = OptionalInt.of(2);
        }
        HashBuilderOperator.HashBuilderOperatorFactory hashBuilder = new HashBuilderOperator.HashBuilderOperatorFactory(2, new PlanNodeId("test"), source.getTypes(), (List)ImmutableList.of((Object)0, (Object)1), (Map)ImmutableMap.of(), Ints.asList((int[])new int[]{0}), hashChannel, false, Optional.empty(), Optional.empty(), (List)ImmutableList.of(), 1500000, 1, (PagesIndex.Factory)new PagesIndex.TestingFactory(false), false, SingleStreamSpillerFactory.unsupportedSingleStreamSpillerFactory());
        driversBuilder.add((Object)hashBuilder);
        DriverFactory hashBuildDriverFactory = new DriverFactory(0, true, false, (List)driversBuilder.build(), OptionalInt.empty());
        Driver hashBuildDriver = hashBuildDriverFactory.createDriver(taskContext.addPipelineContext(0, true, false).addDriverContext());
        hashBuildDriverFactory.noMoreDrivers();
        ImmutableList.Builder joinDriversBuilder = ImmutableList.builder();
        joinDriversBuilder.add((Object)this.lineItemTableScan);
        source = this.lineItemTableScan;
        hashChannel = OptionalInt.empty();
        if (this.hashEnabled) {
            source = this.createHashProjectOperator(1, new PlanNodeId("test"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
            joinDriversBuilder.add((Object)source);
            hashChannel = OptionalInt.of(2);
        }
        OperatorFactory joinOperator = LOOKUP_JOIN_OPERATORS.innerJoin(2, new PlanNodeId("test"), hashBuilder.getLookupSourceFactory(), source.getTypes(), Ints.asList((int[])new int[]{0}), hashChannel, Optional.empty(), OptionalInt.empty(), PartitioningSpillerFactory.unsupportedPartitioningSpillerFactory());
        joinDriversBuilder.add((Object)joinOperator);
        joinDriversBuilder.add((Object)new NullOutputOperator.NullOutputOperatorFactory(3, new PlanNodeId("test"), joinOperator.getTypes()));
        DriverFactory joinDriverFactory = new DriverFactory(1, true, true, (List)joinDriversBuilder.build(), OptionalInt.empty());
        Driver joinDriver = joinDriverFactory.createDriver(taskContext.addPipelineContext(1, true, true).addDriverContext());
        joinDriverFactory.noMoreDrivers();
        return ImmutableList.of((Object)hashBuildDriver, (Object)joinDriver);
    }

    public static void main(String[] args) {
        new HashBuildAndJoinBenchmark(TestingSession.testSessionBuilder().build(), BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        new HashBuildAndJoinBenchmark(TestingSession.testSessionBuilder().build(), BenchmarkQueryRunner.createLocalQueryRunnerHashEnabled()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

