/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.Session;
import com.facebook.presto.benchmark.AbstractBenchmark;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AllowAllAccessControl;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spiller.SpillSpaceTracker;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.TransactionId;
import com.google.common.collect.ImmutableMap;
import io.airlift.stats.CpuTimer;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public abstract class AbstractOperatorBenchmark
extends AbstractBenchmark {
    protected final LocalQueryRunner localQueryRunner;
    protected final Session session;

    protected AbstractOperatorBenchmark(LocalQueryRunner localQueryRunner, String benchmarkName, int warmupIterations, int measuredIterations) {
        this(localQueryRunner.getDefaultSession(), localQueryRunner, benchmarkName, warmupIterations, measuredIterations);
    }

    protected AbstractOperatorBenchmark(Session session, LocalQueryRunner localQueryRunner, String benchmarkName, int warmupIterations, int measuredIterations) {
        super(benchmarkName, warmupIterations, measuredIterations);
        this.localQueryRunner = Objects.requireNonNull(localQueryRunner, "localQueryRunner is null");
        TransactionId transactionId = localQueryRunner.getTransactionManager().beginTransaction(false);
        this.session = session.beginTransactionId(transactionId, localQueryRunner.getTransactionManager(), (AccessControl)new AllowAllAccessControl());
    }

    @Override
    protected void tearDown() {
        this.localQueryRunner.getTransactionManager().asyncAbort(this.session.getRequiredTransactionId());
        super.tearDown();
    }

    protected OperatorFactory createTableScanOperator(int operatorId, PlanNodeId planNodeId, String tableName, String ... columnNames) {
        return this.localQueryRunner.createTableScanOperator(this.session, operatorId, planNodeId, tableName, columnNames);
    }

    protected OperatorFactory createHashProjectOperator(int operatorId, PlanNodeId planNodeId, List<Type> types) {
        return this.localQueryRunner.createHashProjectOperator(this.session, operatorId, planNodeId, types);
    }

    protected abstract List<Driver> createDrivers(TaskContext var1);

    protected Map<String, Long> execute(TaskContext taskContext) {
        List<Driver> drivers = this.createDrivers(taskContext);
        long peakMemory = 0L;
        boolean done = false;
        while (!done) {
            boolean processed = false;
            for (Driver driver : drivers) {
                if (driver.isFinished()) continue;
                driver.process();
                long lastPeakMemory = peakMemory;
                peakMemory = (long)taskContext.getTaskStats().getMemoryReservation().getValue(DataSize.Unit.BYTE);
                if (peakMemory <= lastPeakMemory) {
                    peakMemory = lastPeakMemory;
                }
                processed = true;
            }
            done = !processed;
        }
        return ImmutableMap.of((Object)"peak_memory", (Object)peakMemory);
    }

    @Override
    protected Map<String, Long> runOnce() {
        Session session = TestingSession.testSessionBuilder().setSystemProperty("optimizer.optimize-hash-generation", "true").build();
        MemoryPool memoryPool = new MemoryPool(new MemoryPoolId("test"), new DataSize(1.0, DataSize.Unit.GIGABYTE));
        MemoryPool systemMemoryPool = new MemoryPool(new MemoryPoolId("testSystem"), new DataSize(1.0, DataSize.Unit.GIGABYTE));
        SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(new DataSize(1.0, DataSize.Unit.GIGABYTE));
        TaskContext taskContext = new QueryContext(new QueryId("test"), new DataSize(256.0, DataSize.Unit.MEGABYTE), memoryPool, systemMemoryPool, (Executor)this.localQueryRunner.getExecutor(), this.localQueryRunner.getScheduler(), new DataSize(256.0, DataSize.Unit.MEGABYTE), spillSpaceTracker).addTaskContext(new TaskStateMachine(new TaskId("query", 0, 0), (Executor)this.localQueryRunner.getExecutor()), session, false, false);
        CpuTimer cpuTimer = new CpuTimer();
        Map<String, Long> executionStats = this.execute(taskContext);
        CpuTimer.CpuDuration executionTime = cpuTimer.elapsedTime();
        TaskStats taskStats = taskContext.getTaskStats();
        long inputRows = taskStats.getRawInputPositions();
        long inputBytes = taskStats.getRawInputDataSize().toBytes();
        long outputRows = taskStats.getOutputPositions();
        long outputBytes = taskStats.getOutputDataSize().toBytes();
        double inputMegaBytes = new DataSize((double)inputBytes, DataSize.Unit.BYTE).getValue(DataSize.Unit.MEGABYTE);
        return ImmutableMap.builder().putAll(executionStats).put((Object)"elapsed_millis", (Object)executionTime.getWall().toMillis()).put((Object)"input_rows_per_second", (Object)((long)((double)inputRows / executionTime.getWall().getValue(TimeUnit.SECONDS)))).put((Object)"output_rows_per_second", (Object)((long)((double)outputRows / executionTime.getWall().getValue(TimeUnit.SECONDS)))).put((Object)"input_megabytes", (Object)((long)inputMegaBytes)).put((Object)"input_megabytes_per_second", (Object)((long)(inputMegaBytes / executionTime.getWall().getValue(TimeUnit.SECONDS)))).put((Object)"wall_nanos", (Object)executionTime.getWall().roundTo(TimeUnit.NANOSECONDS)).put((Object)"cpu_nanos", (Object)executionTime.getCpu().roundTo(TimeUnit.NANOSECONDS)).put((Object)"user_nanos", (Object)executionTime.getUser().roundTo(TimeUnit.NANOSECONDS)).put((Object)"input_rows", (Object)inputRows).put((Object)"input_bytes", (Object)inputBytes).put((Object)"output_rows", (Object)outputRows).put((Object)"output_bytes", (Object)outputBytes).build();
    }
}

