/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractSimpleOperatorBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.AggregationOperator;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.PageFilter;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.util.DateTimeUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class HandTpchQuery6
extends AbstractSimpleOperatorBenchmark {
    private final InternalAggregationFunction doubleSum;

    public HandTpchQuery6(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hand_tpch_query_6", 10, 100);
        this.doubleSum = localQueryRunner.getMetadata().getFunctionRegistry().getAggregateFunctionImplementation(new Signature("sum", FunctionKind.AGGREGATE, DoubleType.DOUBLE.getTypeSignature(), new TypeSignature[]{DoubleType.DOUBLE.getTypeSignature()}));
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, new PlanNodeId("test"), "lineitem", "extendedprice", "discount", "shipdate", "quantity");
        Supplier projection = new PageFunctionCompiler(this.localQueryRunner.getMetadata()).compileProjection((RowExpression)Expressions.field((int)0, (Type)BigintType.BIGINT), Optional.empty());
        FilterAndProjectOperator.FilterAndProjectOperatorFactory tpchQuery6Operator = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(1, new PlanNodeId("test"), () -> HandTpchQuery6.lambda$createOperatorFactories$0((Supplier)projection), (List)ImmutableList.of((Object)DoubleType.DOUBLE));
        AggregationOperator.AggregationOperatorFactory aggregationOperator = new AggregationOperator.AggregationOperatorFactory(2, new PlanNodeId("test"), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)this.doubleSum.bind((List)ImmutableList.of((Object)0), Optional.empty())));
        return ImmutableList.of((Object)tableScanOperator, (Object)tpchQuery6Operator, (Object)aggregationOperator);
    }

    public static void main(String[] args) {
        new HandTpchQuery6(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }

    private static /* synthetic */ PageProcessor lambda$createOperatorFactories$0(Supplier projection) {
        return new PageProcessor(Optional.of(new TpchQuery6Filter()), (List)ImmutableList.of(projection.get()));
    }

    public static class TpchQuery6Filter
    implements PageFilter {
        private static final int MIN_SHIP_DATE = DateTimeUtils.parseDate((String)"1994-01-01");
        private static final int MAX_SHIP_DATE = DateTimeUtils.parseDate((String)"1995-01-01");
        private static final InputChannels INPUT_CHANNELS = new InputChannels(new int[]{1, 2, 3});
        private boolean[] selectedPositions = new boolean[0];

        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return INPUT_CHANNELS;
        }

        public SelectedPositions filter(ConnectorSession session, Page page) {
            if (this.selectedPositions.length < page.getPositionCount()) {
                this.selectedPositions = new boolean[page.getPositionCount()];
            }
            for (int position = 0; position < page.getPositionCount(); ++position) {
                this.selectedPositions[position] = TpchQuery6Filter.filter(page, position);
            }
            return PageFilter.positionsArrayToSelectedPositions((boolean[])this.selectedPositions, (int)page.getPositionCount());
        }

        private static boolean filter(Page page, int position) {
            Block discountBlock = page.getBlock(0);
            Block shipDateBlock = page.getBlock(1);
            Block quantityBlock = page.getBlock(2);
            return !shipDateBlock.isNull(position) && DateType.DATE.getLong(shipDateBlock, position) >= (long)MIN_SHIP_DATE && !shipDateBlock.isNull(position) && DateType.DATE.getLong(shipDateBlock, position) < (long)MAX_SHIP_DATE && !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) >= 0.05 && !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) <= 0.07 && !quantityBlock.isNull(position) && BigintType.BIGINT.getLong(quantityBlock, position) < 24L;
        }
    }
}

