/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractSimpleOperatorBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class PredicateFilterBenchmark
extends AbstractSimpleOperatorBenchmark {
    public PredicateFilterBenchmark(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "predicate_filter", 5, 50);
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "totalprice");
        CallExpression filter = Expressions.call((Signature)Signature.internalOperator((OperatorType)OperatorType.GREATER_THAN_OR_EQUAL, (TypeSignature)BooleanType.BOOLEAN.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature(), (Object)DoubleType.DOUBLE.getTypeSignature())), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)DoubleType.DOUBLE), Expressions.constant((Object)50000.0, (Type)DoubleType.DOUBLE)});
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(this.localQueryRunner.getMetadata());
        Supplier pageProcessor = expressionCompiler.compilePageProcessor(Optional.of(filter), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)DoubleType.DOUBLE)));
        FilterAndProjectOperator.FilterAndProjectOperatorFactory filterAndProjectOperator = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(1, new PlanNodeId("test"), pageProcessor, (List)ImmutableList.of((Object)DoubleType.DOUBLE));
        return ImmutableList.of((Object)tableScanOperator, (Object)filterAndProjectOperator);
    }

    public static void main(String[] args) {
        new PredicateFilterBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

