/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.Session;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class BenchmarkQueryRunner {
    private BenchmarkQueryRunner() {
    }

    public static LocalQueryRunner createLocalQueryRunnerHashEnabled() {
        return BenchmarkQueryRunner.createLocalQueryRunner(true);
    }

    public static LocalQueryRunner createLocalQueryRunner() {
        return BenchmarkQueryRunner.createLocalQueryRunner(false);
    }

    public static LocalQueryRunner createLocalQueryRunner(boolean hashingEnabled) {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny");
        if (hashingEnabled) {
            sessionBuilder.setSystemProperty("optimizer.optimize_hash_generation", "true");
        }
        Session session = sessionBuilder.build();
        LocalQueryRunner localQueryRunner = new LocalQueryRunner(session);
        localQueryRunner.createCatalog("tpch", (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        return localQueryRunner;
    }
}

