/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractOperatorBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.NullOutputOperator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

public class HashJoinBenchmark
extends AbstractOperatorBenchmark {
    private LookupSourceSupplier lookupSourceSupplier;

    public HashJoinBenchmark(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hash_join", 4, 50);
    }

    @Override
    protected List<Driver> createDrivers(TaskContext taskContext) {
        if (this.lookupSourceSupplier == null) {
            OperatorFactory ordersTableScan = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "orderkey", "totalprice");
            HashBuilderOperator.HashBuilderOperatorFactory hashBuilder = new HashBuilderOperator.HashBuilderOperatorFactory(1, new PlanNodeId("test"), ordersTableScan.getTypes(), (Map)ImmutableMap.of(), Ints.asList((int[])new int[]{0}), Optional.empty(), false, Optional.empty(), 1500000);
            DriverContext driverContext = taskContext.addPipelineContext(false, false).addDriverContext();
            Driver driver = new DriverFactory(false, false, (List)ImmutableList.of((Object)ordersTableScan, (Object)hashBuilder), OptionalInt.empty()).createDriver(driverContext);
            while (!driver.isFinished()) {
                driver.process();
            }
            this.lookupSourceSupplier = hashBuilder.getLookupSourceSupplier();
        }
        OperatorFactory lineItemTableScan = this.createTableScanOperator(0, new PlanNodeId("test"), "lineitem", "orderkey", "quantity");
        OperatorFactory joinOperator = LookupJoinOperators.innerJoin((int)1, (PlanNodeId)new PlanNodeId("test"), (LookupSourceSupplier)this.lookupSourceSupplier, (List)lineItemTableScan.getTypes(), (List)Ints.asList((int[])new int[]{0}), Optional.empty(), (boolean)false);
        NullOutputOperator.NullOutputOperatorFactory output = new NullOutputOperator.NullOutputOperatorFactory(2, new PlanNodeId("test"), joinOperator.getTypes());
        DriverFactory driverFactory = new DriverFactory(true, true, (List)ImmutableList.of((Object)lineItemTableScan, (Object)joinOperator, (Object)output), OptionalInt.empty());
        DriverContext driverContext = taskContext.addPipelineContext(true, true).addDriverContext();
        Driver driver = driverFactory.createDriver(driverContext);
        return ImmutableList.of((Object)driver);
    }

    public static void main(String[] args) {
        new HashJoinBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

