/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.benchmark.AbstractOperatorBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.NullOutputOperator;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Optional;

public class HashBuildAndJoinBenchmark
extends AbstractOperatorBenchmark {
    private final boolean hashEnabled;
    private final OperatorFactory ordersTableScan = this.createTableScanOperator(0, "orders", "orderkey", "totalprice");
    private final OperatorFactory lineItemTableScan = this.createTableScanOperator(0, "lineitem", "orderkey", "quantity");

    public HashBuildAndJoinBenchmark(Session session, LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hash_build_and_join_hash_enabled_" + HashBuildAndJoinBenchmark.isHashEnabled(session), 4, 5);
        this.hashEnabled = HashBuildAndJoinBenchmark.isHashEnabled(session);
    }

    private static boolean isHashEnabled(Session session) {
        return SystemSessionProperties.isOptimizeHashGenerationEnabled((Session)session);
    }

    @Override
    protected List<Driver> createDrivers(TaskContext taskContext) {
        ImmutableList.Builder driversBuilder = ImmutableList.builder();
        driversBuilder.add((Object)this.ordersTableScan);
        OperatorFactory source = this.ordersTableScan;
        Optional<Object> hashChannel = Optional.empty();
        if (this.hashEnabled) {
            source = this.createHashProjectOperator(1, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE));
            driversBuilder.add((Object)source);
            hashChannel = Optional.of(2);
        }
        HashBuilderOperator.HashBuilderOperatorFactory hashBuilder = new HashBuilderOperator.HashBuilderOperatorFactory(2, source.getTypes(), Ints.asList((int[])new int[]{0}), hashChannel, 1500000);
        driversBuilder.add((Object)hashBuilder);
        DriverFactory hashBuildDriverFactory = new DriverFactory(true, false, (List)driversBuilder.build());
        Driver hashBuildDriver = hashBuildDriverFactory.createDriver(taskContext.addPipelineContext(true, false).addDriverContext());
        ImmutableList.Builder joinDriversBuilder = ImmutableList.builder();
        joinDriversBuilder.add((Object)this.lineItemTableScan);
        source = this.lineItemTableScan;
        hashChannel = Optional.empty();
        if (this.hashEnabled) {
            source = this.createHashProjectOperator(1, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
            joinDriversBuilder.add((Object)source);
            hashChannel = Optional.of(2);
        }
        OperatorFactory joinOperator = LookupJoinOperators.innerJoin((int)2, (LookupSourceSupplier)hashBuilder.getLookupSourceSupplier(), (List)source.getTypes(), (List)Ints.asList((int[])new int[]{0}), hashChannel);
        joinDriversBuilder.add((Object)joinOperator);
        joinDriversBuilder.add((Object)new NullOutputOperator.NullOutputOperatorFactory(3, joinOperator.getTypes()));
        DriverFactory joinDriverFactory = new DriverFactory(true, true, (List)joinDriversBuilder.build());
        Driver joinDriver = joinDriverFactory.createDriver(taskContext.addPipelineContext(true, true).addDriverContext());
        return ImmutableList.of((Object)hashBuildDriver, (Object)joinDriver);
    }

    public static void main(String[] args) {
        new HashBuildAndJoinBenchmark(TestingSession.testSessionBuilder().build(), BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        new HashBuildAndJoinBenchmark(TestingSession.testSessionBuilder().build(), BenchmarkQueryRunner.createLocalQueryRunnerHashEnabled()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

