/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.source;

import com.facebook.presto.benchmark.framework.BenchmarkQuery;
import com.facebook.presto.benchmark.framework.BenchmarkSuite;
import com.facebook.presto.benchmark.source.PhaseSpecificationsColumnMapper;
import com.facebook.presto.benchmark.source.StringToStringMapColumnMapper;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterColumnMapper;
import org.jdbi.v3.sqlobject.config.RegisterColumnMappers;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

@RegisterColumnMappers(value={@RegisterColumnMapper(value=StringToStringMapColumnMapper.class), @RegisterColumnMapper(value=PhaseSpecificationsColumnMapper.class)})
public interface BenchmarkSuiteDao {
    @SqlUpdate(value="CREATE TABLE <table_name> (\n  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,\n  `suite` varchar(256) NOT NULL,\n  `query_set` varchar(256) NOT NULL,\n  `phases` mediumtext NOT NULL,\n  `session_properties` mediumtext DEFAULT NULL,\n  `created_by` varchar(256) NOT NULL,\n  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,\n  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n  PRIMARY KEY (`id`),\n  UNIQUE KEY suite (`suite`))")
    public void createBenchmarkSuitesTable(@Define(value="table_name") String var1);

    @SqlUpdate(value="CREATE TABLE <table_name> (\n  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,\n  `query_set` varchar(256) NOT NULL,\n  `name` varchar(256) NOT NULL,\n  `catalog` varchar(256) NOT NULL,\n  `schema` varchar(256) NOT NULL,\n  `query` mediumtext NOT NULL,\n  `session_properties` mediumtext DEFAULT NULL,\n  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,\n  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n  PRIMARY KEY (`id`),\n  UNIQUE KEY `query_set_name` (`query_set`,`name`))")
    public void createBenchmarkQueriesTable(@Define(value="table_name") String var1);

    @SqlQuery(value="SELECT\n  `suite`,\n  `query_set`,\n  `phases`,\n  `session_properties`\nFROM\n  <table_name>\nWHERE\n  `suite`  = :suite\n")
    @RegisterConstructorMapper(value=BenchmarkSuite.JdbiBuilder.class)
    public BenchmarkSuite.JdbiBuilder getBenchmarkSuite(@Define(value="table_name") String var1, @Bind(value="suite") String var2);

    @SqlQuery(value="SELECT\n  `name`,\n  `catalog`,\n  `schema`,\n  `query`,\n  `session_properties`\nFROM\n  <table_name>\nWHERE\n  `query_set`  = :query_set\n")
    @RegisterConstructorMapper(value=BenchmarkQuery.class)
    public List<BenchmarkQuery> getBenchmarkQueries(@Define(value="table_name") String var1, @Bind(value="query_set") String var2);
}

