/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.prestoaction;

import com.facebook.presto.benchmark.framework.QueryException;
import com.facebook.presto.benchmark.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.connector.thrift.ThriftErrorCode;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.plugin.jdbc.JdbcErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.EOFException;
import java.io.UncheckedIOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class PrestoExceptionClassifier
implements SqlExceptionClassifier {
    private static final Set<ErrorCodeSupplier> DEFAULT_ERRORS = ImmutableSet.builder().addAll(Arrays.asList(StandardErrorCode.values())).addAll(Arrays.asList(HiveErrorCode.values())).addAll(Arrays.asList(HiveErrorCode.values())).addAll(Arrays.asList(JdbcErrorCode.values())).addAll(Arrays.asList(ThriftErrorCode.values())).build();
    private final Map<Integer, ErrorCodeSupplier> errorByCode;

    public PrestoExceptionClassifier(Set<ErrorCodeSupplier> additionalErrors) {
        this.errorByCode = (Map)ImmutableSet.builder().addAll(DEFAULT_ERRORS).addAll(additionalErrors).build().stream().collect(ImmutableMap.toImmutableMap(errorCode -> errorCode.toErrorCode().getCode(), Function.identity()));
    }

    @Override
    public QueryException createException(Optional<QueryStats> queryStats, SQLException cause) {
        Optional<Throwable> clusterConnectionExceptionCause = PrestoExceptionClassifier.getClusterConnectionExceptionCause(cause);
        if (clusterConnectionExceptionCause.isPresent()) {
            return QueryException.forClusterConnection(clusterConnectionExceptionCause.get());
        }
        Optional<ErrorCodeSupplier> errorCode = Optional.ofNullable(this.errorByCode.get(cause.getErrorCode()));
        return QueryException.forPresto(cause, errorCode, queryStats);
    }

    private static Optional<Throwable> getClusterConnectionExceptionCause(Throwable t) {
        while (t != null) {
            if (t instanceof SocketTimeoutException || t instanceof SocketException || t instanceof EOFException || t instanceof UncheckedIOException || t instanceof TimeoutException || t.getClass().equals(RuntimeException.class) && t.getMessage() != null && t.getMessage().contains("Error fetching next at")) {
                return Optional.of(t);
            }
            t = t.getCause();
        }
        return Optional.empty();
    }
}

