/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.prestoaction;

import com.facebook.presto.benchmark.framework.BenchmarkQuery;
import com.facebook.presto.benchmark.framework.QueryException;
import com.facebook.presto.benchmark.framework.QueryResult;
import com.facebook.presto.benchmark.prestoaction.PrestoAction;
import com.facebook.presto.benchmark.prestoaction.PrestoClusterConfig;
import com.facebook.presto.benchmark.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.benchmark.retry.RetryConfig;
import com.facebook.presto.benchmark.retry.RetryDriver;
import com.facebook.presto.jdbc.PrestoConnection;
import com.facebook.presto.jdbc.PrestoStatement;
import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class JdbcPrestoAction
implements PrestoAction {
    private static final String QUERY_MAX_EXECUTION_TIME = "query_max_execution_time";
    private final SqlExceptionClassifier exceptionClassifier;
    private final BenchmarkQuery benchmarkQuery;
    private final String jdbcUrl;
    private final Duration queryTimeout;
    private final RetryDriver networkRetry;

    public JdbcPrestoAction(SqlExceptionClassifier exceptionClassifier, BenchmarkQuery benchmarkQuery, PrestoClusterConfig prestoClusterConfig, RetryConfig networkRetryConfig) {
        this.exceptionClassifier = Objects.requireNonNull(exceptionClassifier, "exceptionClassifier is null");
        this.benchmarkQuery = Objects.requireNonNull(benchmarkQuery, "benchmarkQuery is null");
        this.jdbcUrl = Objects.requireNonNull(prestoClusterConfig.getJdbcUrl(), "jdbcUrl is null");
        this.queryTimeout = Objects.requireNonNull(prestoClusterConfig.getQueryTimeout(), "queryTimeout is null");
        this.networkRetry = new RetryDriver(networkRetryConfig, exception -> exception instanceof QueryException && ((QueryException)exception).getType() == QueryException.Type.CLUSTER_CONNECTION);
    }

    @Override
    public QueryStats execute(com.facebook.presto.sql.tree.Statement statement) {
        return this.execute(statement, Optional.empty()).getQueryStats();
    }

    @Override
    public <R> QueryResult<R> execute(com.facebook.presto.sql.tree.Statement statement, PrestoAction.ResultSetConverter<R> converter) {
        return this.execute(statement, Optional.of(converter));
    }

    private <R> QueryResult<R> execute(com.facebook.presto.sql.tree.Statement statement, Optional<PrestoAction.ResultSetConverter<R>> converter) {
        return this.networkRetry.run("presto-cluster-connection", () -> this.executeOnce(statement, converter));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <R> QueryResult<R> executeOnce(com.facebook.presto.sql.tree.Statement statement, Optional<PrestoAction.ResultSetConverter<R>> converter) {
        String query = SqlFormatter.formatSql((Node)statement, Optional.empty());
        ProgressMonitor progressMonitor = new ProgressMonitor();
        try (PrestoConnection connection = this.getConnection();){
            QueryResult queryResult;
            block25: {
                Statement jdbcStatement = connection.createStatement();
                try {
                    PrestoStatement prestoStatement = jdbcStatement.unwrap(PrestoStatement.class);
                    prestoStatement.setProgressMonitor((Consumer)progressMonitor);
                    ImmutableList.Builder rows = ImmutableList.builder();
                    if (converter.isPresent()) {
                        try (ResultSet resultSet = jdbcStatement.executeQuery(query);){
                            while (resultSet.next()) {
                                rows.add(converter.get().apply(resultSet));
                            }
                        }
                    } else {
                        boolean moreResults = jdbcStatement.execute(query);
                        if (moreResults) {
                            this.consumeResultSet(jdbcStatement.getResultSet());
                        }
                        do {
                            if (!(moreResults = jdbcStatement.getMoreResults())) continue;
                            this.consumeResultSet(jdbcStatement.getResultSet());
                        } while (moreResults || jdbcStatement.getUpdateCount() != -1);
                    }
                    Preconditions.checkState((boolean)progressMonitor.getLastQueryStats().isPresent(), (Object)"lastQueryStats is missing");
                    queryResult = new QueryResult(rows.build(), progressMonitor.getLastQueryStats().get());
                    if (jdbcStatement == null) break block25;
                }
                catch (Throwable throwable) {
                    if (jdbcStatement != null) {
                        try {
                            jdbcStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jdbcStatement.close();
            }
            return queryResult;
        }
        catch (SQLException e) {
            throw this.exceptionClassifier.createException(progressMonitor.getLastQueryStats(), e);
        }
    }

    private void consumeResultSet(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
        }
    }

    private PrestoConnection getConnection() throws SQLException {
        PrestoConnection connection = DriverManager.getConnection(this.jdbcUrl, "user", null).unwrap(PrestoConnection.class);
        try {
            connection.setClientInfo("ApplicationName", "benchmark-test");
            connection.setCatalog(this.benchmarkQuery.getCatalog());
            connection.setSchema(this.benchmarkQuery.getSchema());
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            // empty catch block
        }
        ImmutableMap sessionProperties = ImmutableMap.builder().putAll(this.benchmarkQuery.getSessionProperties()).put((Object)QUERY_MAX_EXECUTION_TIME, (Object)this.queryTimeout.toString()).build();
        for (Map.Entry entry : sessionProperties.entrySet()) {
            connection.setSessionProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return connection;
    }

    static class ProgressMonitor
    implements Consumer<QueryStats> {
        private Optional<QueryStats> queryStats = Optional.empty();

        ProgressMonitor() {
        }

        @Override
        public synchronized void accept(QueryStats queryStats) {
            this.queryStats = Optional.of(Objects.requireNonNull(queryStats, "queryStats is null"));
        }

        public synchronized Optional<QueryStats> getLastQueryStats() {
            return this.queryStats;
        }
    }
}

