/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.framework;

import com.facebook.airlift.event.client.EventClient;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.benchmark.event.BenchmarkQueryEvent;
import com.facebook.presto.benchmark.framework.BenchmarkQuery;
import com.facebook.presto.benchmark.framework.PhaseExecutor;
import com.facebook.presto.benchmark.framework.PhaseSpecification;
import com.facebook.presto.benchmark.framework.QueryException;
import com.facebook.presto.benchmark.prestoaction.PrestoAction;
import com.facebook.presto.benchmark.prestoaction.PrestoActionFactory;
import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Throwables;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractPhaseExecutor<T extends PhaseSpecification>
implements PhaseExecutor<T> {
    private static final Logger log = Logger.get(AbstractPhaseExecutor.class);
    private final SqlParser sqlParser;
    private final ParsingOptions parsingOptions;
    private final PrestoActionFactory prestoActionFactory;
    private final Set<EventClient> eventClients;
    private final String testId;

    protected AbstractPhaseExecutor(SqlParser sqlParser, ParsingOptions parsingOptions, PrestoActionFactory prestoActionFactory, Set<EventClient> eventClients, String testId) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.parsingOptions = Objects.requireNonNull(parsingOptions, "parsingOptions is null");
        this.prestoActionFactory = Objects.requireNonNull(prestoActionFactory, "prestoActionFactory is null");
        this.eventClients = Objects.requireNonNull(eventClients, "eventClients is null");
        this.testId = Objects.requireNonNull(testId, "testId is null");
    }

    protected BenchmarkQueryEvent runQuery(BenchmarkQuery benchmarkQuery) {
        Optional<QueryStats> queryStats = Optional.empty();
        Statement statement = this.sqlParser.createStatement(benchmarkQuery.getQuery(), this.parsingOptions);
        PrestoAction prestoAction = this.prestoActionFactory.get(benchmarkQuery);
        try {
            queryStats = Optional.of(prestoAction.execute(statement));
            return this.buildEvent(benchmarkQuery, queryStats, Optional.empty());
        }
        catch (QueryException e) {
            return this.buildEvent(benchmarkQuery, queryStats, Optional.of(e));
        }
        catch (Throwable t) {
            log.error(t);
            return this.buildEvent(benchmarkQuery, queryStats, Optional.empty());
        }
    }

    private BenchmarkQueryEvent buildEvent(BenchmarkQuery benchmarkQuery, Optional<QueryStats> queryStats, Optional<QueryException> queryException) {
        boolean succeeded = queryStats.isPresent();
        BenchmarkQueryEvent.Status status = succeeded ? BenchmarkQueryEvent.Status.SUCCEEDED : BenchmarkQueryEvent.Status.FAILED;
        Optional<String> errorCode = Optional.empty();
        Optional<String> errorMessage = Optional.empty();
        Optional<String> stackTrace = Optional.empty();
        if (!succeeded && queryException.isPresent()) {
            queryStats = queryException.get().getQueryStats();
            errorCode = queryException.get().getPrestoErrorCode().map(ErrorCodeSupplier::toErrorCode).map(ErrorCode::getName);
            errorMessage = Optional.of(queryException.get().getMessage());
            stackTrace = Optional.of(Throwables.getStackTraceAsString((Throwable)queryException.get().getCause()));
        }
        return new BenchmarkQueryEvent(this.testId, benchmarkQuery.getName(), status, benchmarkQuery.getCatalog(), benchmarkQuery.getSchema(), benchmarkQuery.getQuery(), queryStats, errorCode, errorMessage, stackTrace);
    }

    protected void postEvent(BenchmarkQueryEvent event) {
        for (EventClient eventClient : this.eventClients) {
            eventClient.post((Object[])new BenchmarkQueryEvent[]{event});
        }
    }

    protected static BenchmarkQuery overrideSessionProperties(BenchmarkQuery query, Map<String, String> override) {
        HashMap<String, String> sessionProperties = new HashMap<String, String>(query.getSessionProperties());
        for (Map.Entry<String, String> entry : override.entrySet()) {
            sessionProperties.put(entry.getKey(), entry.getValue());
        }
        return new BenchmarkQuery(query.getName(), query.getQuery(), query.getCatalog(), query.getSchema(), Optional.of(sessionProperties));
    }
}

