/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.prestoaction;

import com.facebook.presto.benchmark.framework.BenchmarkQuery;
import com.facebook.presto.benchmark.prestoaction.JdbcPrestoAction;
import com.facebook.presto.benchmark.prestoaction.PrestoAction;
import com.facebook.presto.benchmark.prestoaction.PrestoActionFactory;
import com.facebook.presto.benchmark.prestoaction.PrestoClusterConfig;
import com.facebook.presto.benchmark.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.benchmark.retry.RetryConfig;
import com.google.inject.Inject;
import java.util.Objects;

public class BenchmarkPrestoActionFactory
implements PrestoActionFactory {
    private final SqlExceptionClassifier exceptionClassifier;
    private final PrestoClusterConfig clusterConfig;
    private final RetryConfig networkRetryConfig;

    @Inject
    public BenchmarkPrestoActionFactory(SqlExceptionClassifier exceptionClassifier, PrestoClusterConfig clusterConfig, RetryConfig networkRetryConfig) {
        this.exceptionClassifier = Objects.requireNonNull(exceptionClassifier, "exceptionClassifier is null");
        this.clusterConfig = Objects.requireNonNull(clusterConfig, "clusterConfig is null");
        this.networkRetryConfig = Objects.requireNonNull(networkRetryConfig, "networkRetryConfig is null");
    }

    @Override
    public PrestoAction get(BenchmarkQuery benchmarkQuery) {
        return new JdbcPrestoAction(this.exceptionClassifier, benchmarkQuery, this.clusterConfig, this.networkRetryConfig);
    }
}

