/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.event;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.event.client.EventClient;
import com.facebook.presto.benchmark.event.JsonEventClient;
import com.facebook.presto.benchmark.framework.BenchmarkRunnerConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import java.util.Map;
import java.util.Set;

public class EventClientModule
extends AbstractConfigurationAwareModule {
    private static final Map<String, Class<? extends EventClient>> DEFAULT_EVENT_CLIENTS = ImmutableMap.builder().put((Object)"json", JsonEventClient.class).build();
    private final Set<String> supportedEventClientTypes;

    public EventClientModule(Set<String> customEventClientType) {
        this.supportedEventClientTypes = ImmutableSet.builder().addAll(DEFAULT_EVENT_CLIENTS.keySet()).addAll(customEventClientType).build();
    }

    protected void setup(Binder binder) {
        Set<String> eventClientTypes = ((BenchmarkRunnerConfig)this.buildConfigObject(BenchmarkRunnerConfig.class)).getEventClients();
        Sets.SetView unsupportedEventClients = Sets.difference(eventClientTypes, this.supportedEventClientTypes);
        Preconditions.checkArgument((boolean)unsupportedEventClients.isEmpty(), (String)"Unsupported EventClient: %s", (Object)unsupportedEventClients);
        Multibinder eventClientBinder = Multibinder.newSetBinder((Binder)binder, EventClient.class);
        for (Map.Entry<String, Class<? extends EventClient>> entry : DEFAULT_EVENT_CLIENTS.entrySet()) {
            if (!eventClientTypes.contains(entry.getKey())) continue;
            eventClientBinder.addBinding().to(entry.getValue()).in(Scopes.SINGLETON);
        }
    }
}

