/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.event;

import com.facebook.airlift.event.client.AbstractEventClient;
import com.facebook.airlift.event.client.JsonEventSerializer;
import com.facebook.presto.benchmark.event.BenchmarkQueryEvent;
import com.facebook.presto.benchmark.framework.BenchmarkRunnerConfig;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Objects;
import javax.inject.Inject;

public class JsonEventClient
extends AbstractEventClient {
    private static final JsonEventSerializer serializer = new JsonEventSerializer(new Class[]{BenchmarkQueryEvent.class});
    private static final JsonFactory factory = new JsonFactory();
    private final PrintStream out;

    @Inject
    public JsonEventClient(BenchmarkRunnerConfig config) throws FileNotFoundException {
        Objects.requireNonNull(config.getJsonEventLogFile(), "jsonEventLogFile is null");
        this.out = config.getJsonEventLogFile().isPresent() ? new PrintStream(config.getJsonEventLogFile().get()) : System.out;
    }

    public <T> void postEvent(T event) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        JsonGenerator generator = factory.createGenerator((OutputStream)buffer, JsonEncoding.UTF8);
        serializer.serialize(event, generator);
        this.out.println(buffer.toString().trim());
    }
}

