/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.source;

import com.facebook.presto.benchmark.framework.BenchmarkSuite;
import com.facebook.presto.benchmark.framework.BenchmarkSuiteInfo;
import com.facebook.presto.benchmark.source.BenchmarkSuiteConfig;
import com.facebook.presto.benchmark.source.BenchmarkSuiteDao;
import com.facebook.presto.benchmark.source.BenchmarkSuiteSupplier;
import com.google.inject.Inject;
import java.util.Objects;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;

public class DbBenchmarkSuiteSupplier
implements BenchmarkSuiteSupplier {
    public static final String BENCHMARK_SUITE_SUPPLIER = "mysql";
    private final Jdbi jdbi;
    private final String suitesTableName;
    private final String queriesTableName;
    private final String suite;

    @Inject
    public DbBenchmarkSuiteSupplier(Jdbi jdbi, BenchmarkSuiteConfig config) {
        this.jdbi = Objects.requireNonNull(jdbi, "jdbi is null");
        this.suitesTableName = Objects.requireNonNull(config.getSuitesTableName(), "suites-table-name is null");
        this.queriesTableName = Objects.requireNonNull(config.getQueriesTableName(), "queries-table-name is null");
        this.suite = Objects.requireNonNull(config.getSuite(), "suite name is null");
    }

    @Override
    public BenchmarkSuite get() {
        BenchmarkSuite benchmarkSuite;
        try (Handle handle = this.jdbi.open();){
            BenchmarkSuiteDao benchmarkDao = (BenchmarkSuiteDao)handle.attach(BenchmarkSuiteDao.class);
            BenchmarkSuiteInfo benchmarkSuiteInfo = benchmarkDao.getBenchmarkSuiteInfo(this.suitesTableName, this.suite);
            benchmarkSuite = new BenchmarkSuite(benchmarkSuiteInfo, benchmarkDao.getBenchmarkQueries(this.queriesTableName, benchmarkSuiteInfo.getQuerySet()));
        }
        return benchmarkSuite;
    }
}

