/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.driver;

import com.facebook.airlift.discovery.client.ServiceDescriptor;
import com.facebook.airlift.discovery.client.ServiceDescriptorsRepresentation;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpClientConfig;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.JsonResponseHandler;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.StringResponseHandler;
import com.facebook.airlift.http.client.jetty.JettyHttpClient;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.benchmark.driver.BenchmarkDriverExecutionException;
import com.facebook.presto.benchmark.driver.BenchmarkQuery;
import com.facebook.presto.benchmark.driver.BenchmarkQueryResult;
import com.facebook.presto.benchmark.driver.Stat;
import com.facebook.presto.benchmark.driver.Suite;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.client.OkHttpUtil;
import com.facebook.presto.client.QueryData;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.StatementClient;
import com.facebook.presto.client.StatementClientFactory;
import com.facebook.presto.client.StatementStats;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import okhttp3.OkHttpClient;

public class BenchmarkQueryRunner
implements Closeable {
    private final int warm;
    private final int runs;
    private final boolean debug;
    private final int maxFailures;
    private final HttpClient httpClient;
    private final OkHttpClient okHttpClient;
    private final List<URI> nodes;
    private int failures;

    public BenchmarkQueryRunner(int warm, int runs, boolean debug, int maxFailures, URI serverUri, Optional<HostAndPort> socksProxy) {
        Preconditions.checkArgument((warm >= 0 ? 1 : 0) != 0, (Object)"warm is negative");
        this.warm = warm;
        Preconditions.checkArgument((runs >= 1 ? 1 : 0) != 0, (Object)"runs must be at least 1");
        this.runs = runs;
        Preconditions.checkArgument((maxFailures >= 0 ? 1 : 0) != 0, (Object)"maxFailures must be at least 0");
        this.maxFailures = maxFailures;
        this.debug = debug;
        Objects.requireNonNull(socksProxy, "socksProxy is null");
        HttpClientConfig httpClientConfig = new HttpClientConfig();
        if (socksProxy.isPresent()) {
            httpClientConfig.setSocksProxy(socksProxy.get());
        }
        this.httpClient = new JettyHttpClient(httpClientConfig.setConnectTimeout(new Duration(10.0, TimeUnit.SECONDS)));
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        OkHttpUtil.setupCookieJar((OkHttpClient.Builder)builder);
        OkHttpUtil.setupSocksProxy((OkHttpClient.Builder)builder, socksProxy);
        this.okHttpClient = builder.build();
        this.nodes = this.getAllNodes(Objects.requireNonNull(serverUri, "serverUri is null"));
    }

    public BenchmarkQueryResult execute(Suite suite, ClientSession session, BenchmarkQuery query) {
        this.failures = 0;
        int i = 0;
        while (i < this.warm) {
            try {
                this.execute(session, query.getName(), query.getSql());
                ++i;
                this.failures = 0;
            }
            catch (BenchmarkDriverExecutionException e) {
                return BenchmarkQueryResult.failResult(suite, query, e.getCause().getMessage());
            }
            catch (Exception e) {
                this.handleFailure(e);
            }
        }
        double[] wallTimeNanos = new double[this.runs];
        double[] processCpuTimeNanos = new double[this.runs];
        double[] queryCpuTimeNanos = new double[this.runs];
        int i2 = 0;
        while (i2 < this.runs) {
            try {
                long startCpuTime = this.getTotalCpuTime();
                long startWallTime = System.nanoTime();
                StatementStats statementStats = this.execute(session, query.getName(), query.getSql());
                long endWallTime = System.nanoTime();
                long endCpuTime = this.getTotalCpuTime();
                wallTimeNanos[i2] = endWallTime - startWallTime;
                processCpuTimeNanos[i2] = endCpuTime - startCpuTime;
                queryCpuTimeNanos[i2] = TimeUnit.MILLISECONDS.toNanos(statementStats.getCpuTimeMillis());
                ++i2;
                this.failures = 0;
            }
            catch (BenchmarkDriverExecutionException e) {
                return BenchmarkQueryResult.failResult(suite, query, e.getCause().getMessage());
            }
            catch (Exception e) {
                this.handleFailure(e);
            }
        }
        return BenchmarkQueryResult.passResult(suite, query, new Stat(wallTimeNanos), new Stat(processCpuTimeNanos), new Stat(queryCpuTimeNanos));
    }

    public List<String> getSchemas(ClientSession session) {
        ImmutableList.Builder schemas;
        AtomicBoolean success;
        this.failures = 0;
        do {
            schemas = ImmutableList.builder();
            success = new AtomicBoolean(true);
            this.execute(session, "show schemas", queryData -> {
                if (queryData.getData() != null) {
                    for (List objects : queryData.getData()) {
                        schemas.add((Object)objects.get(0).toString());
                    }
                }
            }, queryError -> {
                success.set(false);
                this.handleFailure(BenchmarkQueryRunner.getCause(queryError));
            });
        } while (!success.get());
        return schemas.build();
    }

    private StatementStats execute(ClientSession session, String name, String query) {
        return this.execute(session, query, queryData -> {}, resultsError -> {
            throw new BenchmarkDriverExecutionException(String.format("Query %s failed: %s", name, resultsError.getMessage()), BenchmarkQueryRunner.getCause(resultsError));
        });
    }

    private static RuntimeException getCause(QueryError queryError) {
        if (queryError.getFailureInfo() != null) {
            return queryError.getFailureInfo().toException();
        }
        return null;
    }

    private StatementStats execute(ClientSession session, String query, Consumer<QueryData> queryDataConsumer, Consumer<QueryError> queryErrorConsumer) {
        try (StatementClient client = StatementClientFactory.newStatementClient((OkHttpClient)this.okHttpClient, (ClientSession)session, (String)query);){
            while (client.isRunning()) {
                queryDataConsumer.accept(client.currentData());
                if (client.advance()) continue;
            }
            if (client.isClientAborted()) {
                throw new IllegalStateException("Query aborted by user");
            }
            if (client.isClientError()) {
                throw new IllegalStateException("Query is gone (server restarted?)");
            }
            Verify.verify((boolean)client.isFinished());
            QueryError resultsError = client.finalStatusInfo().getError();
            if (resultsError != null) {
                queryErrorConsumer.accept(resultsError);
            }
            StatementStats statementStats = client.finalStatusInfo().getStats();
            return statementStats;
        }
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    public void handleFailure(Exception e) {
        if (this.debug) {
            if (e == null) {
                e = new RuntimeException("Unknown error");
            }
            e.printStackTrace();
        }
        ++this.failures;
        if (this.failures > this.maxFailures) {
            throw new RuntimeException("To many consecutive failures");
        }
        try {
            TimeUnit.SECONDS.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(interruptedException);
        }
    }

    private long getTotalCpuTime() {
        long totalCpuTime = 0L;
        for (URI server : this.nodes) {
            URI addressUri = HttpUriBuilder.uriBuilderFrom((URI)server).replacePath("/v1/jmx/mbean/java.lang:type=OperatingSystem/ProcessCpuTime").build();
            String data = ((StringResponseHandler.StringResponse)this.httpClient.execute(Request.Builder.prepareGet().setUri(addressUri).build(), (ResponseHandler)StringResponseHandler.createStringResponseHandler())).getBody();
            totalCpuTime += Long.parseLong(data.trim());
        }
        return TimeUnit.NANOSECONDS.toNanos(totalCpuTime);
    }

    private List<URI> getAllNodes(URI server) {
        Request request = Request.Builder.prepareGet().setUri(HttpUriBuilder.uriBuilderFrom((URI)server).replacePath("/v1/service/presto").build()).build();
        JsonResponseHandler responseHandler = JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(ServiceDescriptorsRepresentation.class));
        ServiceDescriptorsRepresentation serviceDescriptors = (ServiceDescriptorsRepresentation)this.httpClient.execute(request, (ResponseHandler)responseHandler);
        ImmutableList.Builder addresses = ImmutableList.builder();
        for (ServiceDescriptor serviceDescriptor : serviceDescriptors.getServiceDescriptors()) {
            String httpUri = (String)serviceDescriptor.getProperties().get("http");
            if (httpUri == null) continue;
            addresses.add((Object)URI.create(httpUri));
        }
        return addresses.build();
    }
}

