/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.driver;

import com.facebook.presto.client.ClientSession;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.airline.Option;
import io.airlift.units.Duration;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class BenchmarkDriverOptions {
    @Option(name={"--server"}, title="server", description="Presto server location (default: localhost:8080)")
    public String server = "localhost:8080";
    @Option(name={"--user"}, title="user", description="Username")
    public String user = System.getProperty("user.name");
    @Option(name={"--catalog"}, title="catalog", description="Default catalog")
    public String catalog;
    @Option(name={"--schema"}, title="schema", description="Default schema")
    public String schema;
    @Option(name={"--suite"}, title="suite", description="Suite to execute")
    public List<String> suites = new ArrayList<String>();
    @Option(name={"--suite-config"}, title="suite-config", description="Suites configuration file (default: suite.json)")
    public String suiteConfigFile = "suite.json";
    @Option(name={"--sql"}, title="sql", description="Directory containing sql files (default: sql)")
    public String sqlTemplateDir = "sql";
    @Option(name={"--query"}, title="query", description="Queries to execute")
    public List<String> queries = new ArrayList<String>();
    @Option(name={"--debug"}, title="debug", description="Enable debug information (default: false)")
    public boolean debug;
    @Option(name={"--session"}, title="session", description="Session property (property can be used multiple times; format is key=value)")
    public final List<ClientSessionProperty> sessionProperties = new ArrayList<ClientSessionProperty>();
    @Option(name={"--runs"}, title="runs", description="Number of times to run each query (default: 3)")
    public int runs = 3;
    @Option(name={"--warm"}, title="warm", description="Number of times to run each query for a warm-up (default: 1)")
    public int warm = 1;
    @Option(name={"--max-failures"}, title="max failures", description="Max number of consecutive failures before benchmark fails")
    public int maxFailures = 10;
    @Option(name={"--socks"}, title="socks", description="Socks proxy to use")
    public HostAndPort socksProxy;
    @Option(name={"--client-request-timeout"}, title="client request timeout", description="Client request timeout (default: 2m)")
    public Duration clientRequestTimeout = new Duration(2.0, TimeUnit.MINUTES);
    @Option(name={"--disable-compression"}, title="disable response compression", description="Disable compression of query results")
    public boolean disableCompression;

    public ClientSession getClientSession() {
        return new ClientSession(BenchmarkDriverOptions.parseServer(this.server), this.user, "presto-benchmark", Optional.empty(), (Set)ImmutableSet.of(), null, this.catalog, this.schema, TimeZone.getDefault().getID(), Locale.getDefault(), (Map)ImmutableMap.of(), BenchmarkDriverOptions.toProperties(this.sessionProperties), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), null, this.clientRequestTimeout, this.disableCompression, (Map)ImmutableMap.of());
    }

    private static URI parseServer(String server) {
        if ((server = server.toLowerCase(Locale.ENGLISH)).startsWith("http://") || server.startsWith("https://")) {
            return URI.create(server);
        }
        HostAndPort host = HostAndPort.fromString((String)server);
        try {
            return new URI("http", null, host.getHost(), host.getPortOrDefault(80), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Map<String, String> toProperties(List<ClientSessionProperty> sessionProperties) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ClientSessionProperty sessionProperty : sessionProperties) {
            String name = sessionProperty.getName();
            if (sessionProperty.getCatalog().isPresent()) {
                name = sessionProperty.getCatalog().get() + "." + name;
            }
            builder.put((Object)name, (Object)sessionProperty.getValue());
        }
        return builder.build();
    }

    public static final class ClientSessionProperty {
        private static final Splitter NAME_VALUE_SPLITTER = Splitter.on((char)'=').limit(2);
        private static final Splitter NAME_SPLITTER = Splitter.on((char)'.');
        private final Optional<String> catalog;
        private final String name;
        private final String value;

        public ClientSessionProperty(String property) {
            List nameValue = NAME_VALUE_SPLITTER.splitToList((CharSequence)property);
            Preconditions.checkArgument((nameValue.size() == 2 ? 1 : 0) != 0, (String)"Session property: %s", (Object)property);
            List nameParts = NAME_SPLITTER.splitToList((CharSequence)nameValue.get(0));
            Preconditions.checkArgument((nameParts.size() == 1 || nameParts.size() == 2 ? 1 : 0) != 0, (String)"Invalid session property: %s", (Object)property);
            if (nameParts.size() == 1) {
                this.catalog = Optional.empty();
                this.name = (String)nameParts.get(0);
            } else {
                this.catalog = Optional.of(nameParts.get(0));
                this.name = (String)nameParts.get(1);
            }
            this.value = (String)nameValue.get(1);
            ClientSessionProperty.verifyProperty(this.catalog, this.name, this.value);
        }

        public ClientSessionProperty(Optional<String> catalog, String name, String value) {
            this.catalog = Objects.requireNonNull(catalog, "catalog is null");
            this.name = Objects.requireNonNull(name, "name is null");
            this.value = Objects.requireNonNull(value, "value is null");
            ClientSessionProperty.verifyProperty(catalog, name, value);
        }

        private static void verifyProperty(Optional<String> catalog, String name, String value) {
            Preconditions.checkArgument((!catalog.isPresent() || !catalog.get().isEmpty() ? 1 : 0) != 0, (String)"Invalid session property: %s.%s:%s", catalog, (Object)name, (Object)value);
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Session property name is empty");
            CharsetEncoder charsetEncoder = StandardCharsets.US_ASCII.newEncoder();
            Preconditions.checkArgument((catalog.orElse("").indexOf(61) < 0 ? 1 : 0) != 0, (String)"Session property catalog must not contain '=': %s", (Object)name);
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(catalog.orElse("")), (String)"Session property catalog is not US_ASCII: %s", (Object)name);
            Preconditions.checkArgument((name.indexOf(61) < 0 ? 1 : 0) != 0, (String)"Session property name must not contain '=': %s", (Object)name);
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(name), (String)"Session property name is not US_ASCII: %s", (Object)name);
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(value), (String)"Session property value is not US_ASCII: %s", (Object)value);
        }

        public Optional<String> getCatalog() {
            return this.catalog;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return (this.catalog.isPresent() ? this.catalog.get() + '.' : "") + this.name + '=' + this.value;
        }

        public int hashCode() {
            return Objects.hash(this.catalog, this.name, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ClientSessionProperty other = (ClientSessionProperty)obj;
            return Objects.equals(this.catalog, other.catalog) && Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
        }
    }
}

