/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.driver;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexTemplate {
    private static final Method NAMED_GROUPS_METHOD;
    private final String template;
    private final Pattern pattern;
    private final List<String> fieldNames;

    public RegexTemplate(String template) {
        Map namedGroups;
        this.template = Objects.requireNonNull(template, "template is null");
        try {
            this.pattern = Pattern.compile(template);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid template: " + template, e);
        }
        try {
            namedGroups = (Map)NAMED_GROUPS_METHOD.invoke((Object)this.pattern, new Object[0]);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        ImmutableSortedMap sortedGroups = ImmutableSortedMap.copyOf((Map)ImmutableBiMap.copyOf((Map)namedGroups).inverse());
        this.fieldNames = ImmutableList.copyOf((Collection)sortedGroups.values());
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public Optional<Map<String, String>> parse(String value) {
        Objects.requireNonNull(value, "value is null");
        Matcher matcher = this.pattern.matcher(value);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        ImmutableMap.Builder fieldsBuilder = ImmutableMap.builder();
        for (int index = 0; index < this.fieldNames.size(); ++index) {
            String fieldName = this.fieldNames.get(index);
            String fieldValue = matcher.group(index + 1);
            if (fieldValue == null) continue;
            fieldsBuilder.put((Object)fieldName, (Object)fieldValue);
        }
        ImmutableMap fields = fieldsBuilder.build();
        return Optional.of(fields);
    }

    public String toString() {
        return this.template;
    }

    static {
        try {
            NAMED_GROUPS_METHOD = Pattern.class.getDeclaredMethod("namedGroups", new Class[0]);
            NAMED_GROUPS_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

