/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.Range;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;

public class QueryBuilder {
    private final String quote;

    public QueryBuilder(String quote) {
        this.quote = (String)Preconditions.checkNotNull((Object)quote, (Object)"quote is null");
    }

    public String buildSql(String catalog, String schema, String table, List<JdbcColumnHandle> columns, TupleDomain<ConnectorColumnHandle> tupleDomain) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        Joiner.on((String)", ").appendTo(sql, Iterables.transform(columns, column -> this.quote(column.getColumnName())));
        if (columns.isEmpty()) {
            sql.append("null");
        }
        sql.append(" FROM ");
        if (!Strings.isNullOrEmpty((String)catalog)) {
            sql.append(this.quote(catalog)).append('.');
        }
        if (!Strings.isNullOrEmpty((String)schema)) {
            sql.append(this.quote(schema)).append('.');
        }
        sql.append(this.quote(table));
        List<String> clauses = this.toConjuncts(columns, tupleDomain);
        if (!clauses.isEmpty()) {
            sql.append(" WHERE ").append(Joiner.on((String)" AND ").join(clauses));
        }
        return sql.toString();
    }

    private List<String> toConjuncts(List<JdbcColumnHandle> columns, TupleDomain<ConnectorColumnHandle> tupleDomain) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JdbcColumnHandle column : columns) {
            Domain domain;
            Type type = column.getColumnType();
            if (!type.equals(BigintType.BIGINT) && !type.equals(DoubleType.DOUBLE) && !type.equals(BooleanType.BOOLEAN) || (domain = (Domain)tupleDomain.getDomains().get(column)) == null) continue;
            builder.add((Object)this.toPredicate(column.getColumnName(), domain));
        }
        return builder.build();
    }

    private String toPredicate(String columnName, Domain domain) {
        if (domain.getRanges().isNone() && domain.isNullAllowed()) {
            return this.quote(columnName) + " IS NULL";
        }
        if (domain.getRanges().isAll() && !domain.isNullAllowed()) {
            return this.quote(columnName) + " IS NOT NULL";
        }
        ArrayList<String> disjuncts = new ArrayList<String>();
        ArrayList<Comparable> singleValues = new ArrayList<Comparable>();
        for (Range range : domain.getRanges()) {
            Preconditions.checkState((!range.isAll() ? 1 : 0) != 0);
            if (range.isSingleValue()) {
                singleValues.add(range.getLow().getValue());
                continue;
            }
            ArrayList<String> rangeConjuncts = new ArrayList<String>();
            if (!range.getLow().isLowerUnbounded()) {
                switch (range.getLow().getBound()) {
                    case ABOVE: {
                        rangeConjuncts.add(this.toPredicate(columnName, ">", range.getLow().getValue()));
                        break;
                    }
                    case EXACTLY: {
                        rangeConjuncts.add(this.toPredicate(columnName, ">=", range.getLow().getValue()));
                        break;
                    }
                    case BELOW: {
                        throw new IllegalArgumentException("Low Marker should never use BELOW bound: " + range);
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled bound: " + range.getLow().getBound()));
                    }
                }
            }
            if (!range.getHigh().isUpperUnbounded()) {
                switch (range.getHigh().getBound()) {
                    case ABOVE: {
                        throw new IllegalArgumentException("High Marker should never use ABOVE bound: " + range);
                    }
                    case EXACTLY: {
                        rangeConjuncts.add(this.toPredicate(columnName, "<=", range.getHigh().getValue()));
                        break;
                    }
                    case BELOW: {
                        rangeConjuncts.add(this.toPredicate(columnName, "<", range.getHigh().getValue()));
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled bound: " + range.getHigh().getBound()));
                    }
                }
            }
            Preconditions.checkState((!rangeConjuncts.isEmpty() ? 1 : 0) != 0);
            disjuncts.add("(" + Joiner.on((String)" AND ").join(rangeConjuncts) + ")");
        }
        if (singleValues.size() == 1) {
            disjuncts.add(this.toPredicate(columnName, "=", Iterables.getOnlyElement(singleValues)));
        } else if (singleValues.size() > 1) {
            disjuncts.add(this.quote(columnName) + " IN (" + Joiner.on((String)",").join(Iterables.transform(singleValues, QueryBuilder::encode)) + ")");
        }
        Preconditions.checkState((!disjuncts.isEmpty() ? 1 : 0) != 0);
        if (domain.isNullAllowed()) {
            disjuncts.add(this.quote(columnName) + " IS NULL");
        }
        return "(" + Joiner.on((String)" OR ").join(disjuncts) + ")";
    }

    private String toPredicate(String columnName, String operator, Object value) {
        return this.quote(columnName) + " " + operator + " " + QueryBuilder.encode(value);
    }

    private String quote(String name) {
        name = name.replace(this.quote, this.quote + this.quote);
        return this.quote + name + this.quote;
    }

    private static String encode(Object value) {
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        throw new UnsupportedOperationException("Can't handle type: " + value.getClass().getName());
    }
}

