/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcRecordCursor;
import com.facebook.presto.plugin.jdbc.JdbcSplit;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class JdbcRecordSet
implements RecordSet {
    private final JdbcClient jdbcClient;
    private final List<JdbcColumnHandle> columnHandles;
    private final List<Type> columnTypes;
    private final JdbcSplit split;

    public JdbcRecordSet(JdbcClient jdbcClient, JdbcSplit split, List<JdbcColumnHandle> columnHandles) {
        this.jdbcClient = (JdbcClient)Preconditions.checkNotNull((Object)jdbcClient, (Object)"jdbcClient is null");
        this.split = (JdbcSplit)Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        this.columnHandles = (List)Preconditions.checkNotNull(columnHandles, (Object)"column handles is null");
        ImmutableList.Builder types = ImmutableList.builder();
        for (JdbcColumnHandle column : columnHandles) {
            types.add((Object)column.getColumnType());
        }
        this.columnTypes = types.build();
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new JdbcRecordCursor(this.jdbcClient, this.split, this.columnHandles);
    }
}

