/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcConnectorFactory;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.Plugin;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import java.util.List;
import java.util.Map;

public class JdbcPlugin
implements Plugin {
    private final String name;
    private final Module module;
    private Map<String, String> optionalConfig = ImmutableMap.of();

    public JdbcPlugin(String name, Module module) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.module = (Module)Preconditions.checkNotNull((Object)module, (Object)"module is null");
    }

    public void setOptionalConfig(Map<String, String> optionalConfig) {
        this.optionalConfig = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(optionalConfig, (Object)"optionalConfig is null")));
    }

    public <T> List<T> getServices(Class<T> type) {
        if (type == ConnectorFactory.class) {
            return ImmutableList.of(type.cast(new JdbcConnectorFactory(this.name, this.module, this.optionalConfig, JdbcPlugin.getClassLoader())));
        }
        return ImmutableList.of();
    }

    private static ClassLoader getClassLoader() {
        return (ClassLoader)MoreObjects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)JdbcPlugin.class.getClassLoader());
    }
}

