/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.facebook.presto.plugin.jdbc.JdbcPartition;
import com.facebook.presto.plugin.jdbc.JdbcSplit;
import com.facebook.presto.plugin.jdbc.JdbcTableHandle;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorPartitionResult;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TupleDomain;
import io.airlift.slice.Slice;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public interface JdbcClient {
    public Set<String> getSchemaNames();

    public List<SchemaTableName> getTableNames(@Nullable String var1);

    @Nullable
    public JdbcTableHandle getTableHandle(SchemaTableName var1);

    public List<JdbcColumnHandle> getColumns(JdbcTableHandle var1);

    public ConnectorPartitionResult getPartitions(JdbcTableHandle var1, TupleDomain<ConnectorColumnHandle> var2);

    public ConnectorSplitSource getPartitionSplits(JdbcPartition var1);

    public Connection getConnection(JdbcSplit var1) throws SQLException;

    public String buildSql(JdbcSplit var1, List<JdbcColumnHandle> var2);

    public JdbcOutputTableHandle beginCreateTable(ConnectorTableMetadata var1);

    public void commitCreateTable(JdbcOutputTableHandle var1, Collection<Slice> var2);

    public String buildInsertSql(JdbcOutputTableHandle var1);

    public Connection getConnection(JdbcOutputTableHandle var1) throws SQLException;
}

