/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.facebook.presto.spi.RecordSink;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class JdbcRecordSink
implements RecordSink {
    private final Connection connection;
    private final PreparedStatement statement;
    private final int fieldCount;
    private int field = -1;
    private int batchSize;

    public JdbcRecordSink(JdbcOutputTableHandle handle, JdbcClient jdbcClient) {
        try {
            this.connection = jdbcClient.getConnection(handle);
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
        try {
            this.statement = this.connection.prepareStatement(jdbcClient.buildInsertSql(handle));
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.fieldCount = handle.getColumnNames().size();
    }

    public void beginRecord(long sampleWeight) {
        Preconditions.checkState((this.field == -1 ? 1 : 0) != 0, (Object)"already in record");
        this.field = 0;
    }

    public void finishRecord() {
        Preconditions.checkState((this.field != -1 ? 1 : 0) != 0, (Object)"not in record");
        Preconditions.checkState((this.field == this.fieldCount ? 1 : 0) != 0, (Object)"not all fields set");
        this.field = -1;
        try {
            this.statement.addBatch();
            ++this.batchSize;
            if (this.batchSize >= 1000) {
                this.statement.executeBatch();
                this.connection.commit();
                this.connection.setAutoCommit(false);
                this.batchSize = 0;
            }
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void appendNull() {
        try {
            this.statement.setObject(this.next(), null);
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void appendBoolean(boolean value) {
        try {
            this.statement.setBoolean(this.next(), value);
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void appendLong(long value) {
        try {
            this.statement.setLong(this.next(), value);
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void appendDouble(double value) {
        try {
            this.statement.setDouble(this.next(), value);
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void appendString(byte[] value) {
        try {
            this.statement.setString(this.next(), new String(value, StandardCharsets.UTF_8));
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String commit() {
        try (Connection connection = this.connection;){
            if (this.batchSize > 0) {
                this.statement.executeBatch();
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return "";
    }

    private int next() {
        Preconditions.checkState((this.field != -1 ? 1 : 0) != 0, (Object)"not in record");
        Preconditions.checkState((this.field < this.fieldCount ? 1 : 0) != 0, (Object)"all fields already set");
        ++this.field;
        return this.field;
    }
}

