/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public final class JdbcColumnHandle
implements ConnectorColumnHandle {
    private final String connectorId;
    private final String columnName;
    private final Type columnType;
    private final int ordinalPosition;

    @JsonCreator
    public JdbcColumnHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="columnName") String columnName, @JsonProperty(value="columnType") Type columnType, @JsonProperty(value="ordinalPosition") int ordinalPosition) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        this.columnName = (String)Preconditions.checkNotNull((Object)columnName, (Object)"columnName is null");
        this.columnType = (Type)Preconditions.checkNotNull((Object)columnType, (Object)"columnType is null");
        this.ordinalPosition = ordinalPosition;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public Type getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(this.columnName, this.columnType, this.ordinalPosition, false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JdbcColumnHandle o = (JdbcColumnHandle)obj;
        return Objects.equal((Object)this.connectorId, (Object)o.connectorId) && Objects.equal((Object)this.columnName, (Object)o.columnName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.connectorId, this.columnName});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("columnName", (Object)this.columnName).add("columnType", (Object)this.columnType).add("ordinalPosition", this.ordinalPosition).toString();
    }
}

