/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.plugin.jdbc.JdbcTypeHandle;
import com.facebook.presto.plugin.jdbc.ReadMapping;
import com.google.common.base.CharMatcher;
import io.airlift.slice.Slices;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public final class StandardReadMappings {
    private static final ISOChronology UTC_CHRONOLOGY = ISOChronology.getInstanceUTC();

    private StandardReadMappings() {
    }

    public static ReadMapping booleanReadMapping() {
        return ReadMapping.booleanReadMapping((Type)BooleanType.BOOLEAN, ResultSet::getBoolean);
    }

    public static ReadMapping tinyintReadMapping() {
        return ReadMapping.longReadMapping((Type)TinyintType.TINYINT, ResultSet::getByte);
    }

    public static ReadMapping smallintReadMapping() {
        return ReadMapping.longReadMapping((Type)SmallintType.SMALLINT, ResultSet::getShort);
    }

    public static ReadMapping integerReadMapping() {
        return ReadMapping.longReadMapping((Type)IntegerType.INTEGER, ResultSet::getInt);
    }

    public static ReadMapping bigintReadMapping() {
        return ReadMapping.longReadMapping((Type)BigintType.BIGINT, ResultSet::getLong);
    }

    public static ReadMapping realReadMapping() {
        return ReadMapping.longReadMapping((Type)RealType.REAL, (resultSet, columnIndex) -> Float.floatToRawIntBits(resultSet.getFloat(columnIndex)));
    }

    public static ReadMapping doubleReadMapping() {
        return ReadMapping.doubleReadMapping((Type)DoubleType.DOUBLE, ResultSet::getDouble);
    }

    public static ReadMapping decimalReadMapping(DecimalType decimalType) {
        int scale = decimalType.getScale();
        if (decimalType.isShort()) {
            return ReadMapping.longReadMapping((Type)decimalType, (resultSet, columnIndex) -> Decimals.encodeShortScaledValue((BigDecimal)resultSet.getBigDecimal(columnIndex), (int)scale));
        }
        return ReadMapping.sliceReadMapping((Type)decimalType, (resultSet, columnIndex) -> Decimals.encodeScaledValue((BigDecimal)resultSet.getBigDecimal(columnIndex), (int)scale));
    }

    public static ReadMapping charReadMapping(CharType charType) {
        Objects.requireNonNull(charType, "charType is null");
        return ReadMapping.sliceReadMapping((Type)charType, (resultSet, columnIndex) -> Slices.utf8Slice((String)CharMatcher.is((char)' ').trimTrailingFrom((CharSequence)resultSet.getString(columnIndex))));
    }

    public static ReadMapping varcharReadMapping(VarcharType varcharType) {
        return ReadMapping.sliceReadMapping((Type)varcharType, (resultSet, columnIndex) -> Slices.utf8Slice((String)resultSet.getString(columnIndex)));
    }

    public static ReadMapping varbinaryReadMapping() {
        return ReadMapping.sliceReadMapping((Type)VarbinaryType.VARBINARY, (resultSet, columnIndex) -> Slices.wrappedBuffer((byte[])resultSet.getBytes(columnIndex)));
    }

    public static ReadMapping dateReadMapping() {
        return ReadMapping.longReadMapping((Type)DateType.DATE, (resultSet, columnIndex) -> {
            long localMillis = resultSet.getDate(columnIndex).getTime();
            long utcMillis = ISOChronology.getInstance().getZone().getMillisKeepLocal(DateTimeZone.UTC, localMillis);
            return TimeUnit.MILLISECONDS.toDays(utcMillis);
        });
    }

    public static ReadMapping timeReadMapping() {
        return ReadMapping.longReadMapping((Type)TimeType.TIME, (resultSet, columnIndex) -> {
            Time time = resultSet.getTime(columnIndex);
            return UTC_CHRONOLOGY.millisOfDay().get(time.getTime());
        });
    }

    public static ReadMapping timestampReadMapping() {
        return ReadMapping.longReadMapping((Type)TimestampType.TIMESTAMP, (resultSet, columnIndex) -> {
            Timestamp timestamp = resultSet.getTimestamp(columnIndex);
            return timestamp.getTime();
        });
    }

    public static Optional<ReadMapping> jdbcTypeToPrestoType(JdbcTypeHandle type) {
        int columnSize = type.getColumnSize();
        switch (type.getJdbcType()) {
            case -7: 
            case 16: {
                return Optional.of(StandardReadMappings.booleanReadMapping());
            }
            case -6: {
                return Optional.of(StandardReadMappings.tinyintReadMapping());
            }
            case 5: {
                return Optional.of(StandardReadMappings.smallintReadMapping());
            }
            case 4: {
                return Optional.of(StandardReadMappings.integerReadMapping());
            }
            case -5: {
                return Optional.of(StandardReadMappings.bigintReadMapping());
            }
            case 7: {
                return Optional.of(StandardReadMappings.realReadMapping());
            }
            case 6: 
            case 8: {
                return Optional.of(StandardReadMappings.doubleReadMapping());
            }
            case 2: 
            case 3: {
                int decimalDigits = type.getDecimalDigits();
                int precision = columnSize + Math.max(-decimalDigits, 0);
                if (precision > 38) {
                    return Optional.empty();
                }
                return Optional.of(StandardReadMappings.decimalReadMapping(DecimalType.createDecimalType((int)precision, (int)Math.max(decimalDigits, 0))));
            }
            case -15: 
            case 1: {
                int charLength = Math.min(columnSize, 65536);
                return Optional.of(StandardReadMappings.charReadMapping(CharType.createCharType((long)charLength)));
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                if (columnSize > 0x7FFFFFFE) {
                    return Optional.of(StandardReadMappings.varcharReadMapping(VarcharType.createUnboundedVarcharType()));
                }
                return Optional.of(StandardReadMappings.varcharReadMapping(VarcharType.createVarcharType((int)columnSize)));
            }
            case -4: 
            case -3: 
            case -2: {
                return Optional.of(StandardReadMappings.varbinaryReadMapping());
            }
            case 91: {
                return Optional.of(StandardReadMappings.dateReadMapping());
            }
            case 92: {
                return Optional.of(StandardReadMappings.timeReadMapping());
            }
            case 93: {
                return Optional.of(StandardReadMappings.timestampReadMapping());
            }
        }
        return Optional.empty();
    }
}

