/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcTableHandle;
import com.facebook.presto.plugin.jdbc.optimization.JdbcExpression;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class JdbcTableLayoutHandle
implements ConnectorTableLayoutHandle {
    private final JdbcTableHandle table;
    private final TupleDomain<ColumnHandle> tupleDomain;
    private final Optional<JdbcExpression> additionalPredicate;
    private final String layoutString;

    public JdbcTableLayoutHandle(SqlFunctionProperties properties, JdbcTableHandle table, TupleDomain<ColumnHandle> domain, Optional<JdbcExpression> additionalPredicate) {
        this(table, domain, additionalPredicate, MoreObjects.toStringHelper((String)"").add("domains", (Object)domain.transform(columnHandle -> ((JdbcColumnHandle)columnHandle).getColumnName()).toString(properties)).add("additionalPredicate", (Object)additionalPredicate.map(JdbcExpression::getExpression).orElse("{}")).toString());
    }

    @JsonCreator
    public JdbcTableLayoutHandle(@JsonProperty(value="table") JdbcTableHandle table, @JsonProperty(value="tupleDomain") TupleDomain<ColumnHandle> domain, @JsonProperty(value="additionalPredicate") Optional<JdbcExpression> additionalPredicate, @JsonProperty(value="layoutString") String layoutString) {
        this.table = Objects.requireNonNull(table, "table is null");
        this.tupleDomain = Objects.requireNonNull(domain, "tupleDomain is null");
        this.additionalPredicate = additionalPredicate;
        this.layoutString = Objects.requireNonNull(layoutString, "layoutString is null");
    }

    @JsonProperty
    public Optional<JdbcExpression> getAdditionalPredicate() {
        return this.additionalPredicate;
    }

    @JsonProperty
    public JdbcTableHandle getTable() {
        return this.table;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getTupleDomain() {
        return this.tupleDomain;
    }

    @JsonProperty
    public String getLayoutString() {
        return this.layoutString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcTableLayoutHandle that = (JdbcTableLayoutHandle)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.tupleDomain, that.tupleDomain) && Objects.equals(this.additionalPredicate, that.additionalPredicate);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.tupleDomain, this.additionalPredicate);
    }

    public String toString() {
        return this.layoutString;
    }
}

