/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.plugin.jdbc.JdbcConnector;
import com.facebook.presto.plugin.jdbc.JdbcConnectorId;
import com.facebook.presto.plugin.jdbc.JdbcMetadataCache;
import com.facebook.presto.plugin.jdbc.JdbcMetadataCacheStats;
import com.facebook.presto.plugin.jdbc.JdbcMetadataConfig;
import com.facebook.presto.plugin.jdbc.JdbcMetadataFactory;
import com.facebook.presto.plugin.jdbc.JdbcPageSinkProvider;
import com.facebook.presto.plugin.jdbc.JdbcRecordSetProvider;
import com.facebook.presto.plugin.jdbc.JdbcSessionPropertiesProvider;
import com.facebook.presto.plugin.jdbc.JdbcSplitManager;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.procedure.Procedure;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import java.util.Objects;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;

public class JdbcModule
implements Module {
    private final String connectorId;

    public JdbcModule(String connectorId) {
        this.connectorId = Objects.requireNonNull(connectorId, "connector id is null");
    }

    public void configure(Binder binder) {
        OptionalBinder.newOptionalBinder((Binder)binder, ConnectorAccessControl.class);
        Multibinder.newSetBinder((Binder)binder, Procedure.class);
        binder.bind(JdbcConnectorId.class).toInstance((Object)new JdbcConnectorId(this.connectorId));
        binder.bind(JdbcMetadataCache.class).in(Scopes.SINGLETON);
        binder.bind(JdbcMetadataCacheStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(JdbcMetadataCacheStats.class).as(ObjectNames.generatedNameOf(JdbcMetadataCacheStats.class, (String)this.connectorId));
        binder.bind(JdbcMetadataFactory.class).in(Scopes.SINGLETON);
        binder.bind(JdbcSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(JdbcRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(JdbcPageSinkProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, JdbcSessionPropertiesProvider.class);
        binder.bind(JdbcConnector.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcMetadataConfig.class);
    }
}

