/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class JdbcMetadataConfig {
    private boolean allowDropTable;
    private Duration metadataCacheTtl = new Duration(0.0, TimeUnit.SECONDS);
    private Duration metadataCacheRefreshInterval = new Duration(0.0, TimeUnit.SECONDS);
    private long metadataCacheMaximumSize = 10000L;

    public boolean isAllowDropTable() {
        return this.allowDropTable;
    }

    @Config(value="allow-drop-table")
    @ConfigDescription(value="Allow connector to drop tables")
    public JdbcMetadataConfig setAllowDropTable(boolean allowDropTable) {
        this.allowDropTable = allowDropTable;
        return this;
    }

    @NotNull
    public Duration getMetadataCacheTtl() {
        return this.metadataCacheTtl;
    }

    @MinDuration(value="0ms")
    @Config(value="metadata-cache-ttl")
    public JdbcMetadataConfig setMetadataCacheTtl(Duration metadataCacheTtl) {
        this.metadataCacheTtl = metadataCacheTtl;
        return this;
    }

    @NotNull
    public Duration getMetadataCacheRefreshInterval() {
        return this.metadataCacheRefreshInterval;
    }

    @MinDuration(value="1ms")
    @Config(value="metadata-cache-refresh-interval")
    public JdbcMetadataConfig setMetadataCacheRefreshInterval(Duration metadataCacheRefreshInterval) {
        this.metadataCacheRefreshInterval = metadataCacheRefreshInterval;
        return this;
    }

    public long getMetadataCacheMaximumSize() {
        return this.metadataCacheMaximumSize;
    }

    @Min(value=1L)
    @Config(value="metadata-cache-maximum-size")
    public @Min(value=1L) JdbcMetadataConfig setMetadataCacheMaximumSize(long metadataCacheMaximumSize) {
        this.metadataCacheMaximumSize = metadataCacheMaximumSize;
        return this;
    }
}

