/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcIdentity;
import com.facebook.presto.plugin.jdbc.JdbcMetadataCacheStats;
import com.facebook.presto.plugin.jdbc.JdbcMetadataConfig;
import com.facebook.presto.plugin.jdbc.JdbcTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class JdbcMetadataCache {
    private final JdbcClient jdbcClient;
    private final LoadingCache<KeyAndSession<SchemaTableName>, Optional<JdbcTableHandle>> tableHandleCache;
    private final LoadingCache<KeyAndSession<JdbcTableHandle>, List<JdbcColumnHandle>> columnHandlesCache;

    @Inject
    public JdbcMetadataCache(JdbcClient jdbcClient, JdbcMetadataConfig config, JdbcMetadataCacheStats stats) {
        this(Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"jdbc-metadata-cache-%s")), jdbcClient, stats, OptionalLong.of(config.getMetadataCacheTtl().toMillis()), config.getMetadataCacheRefreshInterval().toMillis() >= config.getMetadataCacheTtl().toMillis() ? OptionalLong.empty() : OptionalLong.of(config.getMetadataCacheRefreshInterval().toMillis()), config.getMetadataCacheMaximumSize());
    }

    public JdbcMetadataCache(ExecutorService executor, JdbcClient jdbcClient, JdbcMetadataCacheStats stats, OptionalLong cacheTtl, OptionalLong refreshInterval, long cacheMaximumSize) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.tableHandleCache = JdbcMetadataCache.newCacheBuilder(cacheTtl, refreshInterval, cacheMaximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadTableHandle), (Executor)executor));
        stats.setTableHandleCache(this.tableHandleCache);
        this.columnHandlesCache = JdbcMetadataCache.newCacheBuilder(cacheTtl, refreshInterval, cacheMaximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadColumnHandles), (Executor)executor));
        stats.setColumnHandlesCache(this.columnHandlesCache);
    }

    public JdbcTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return JdbcMetadataCache.get(this.tableHandleCache, new KeyAndSession<SchemaTableName>(session, tableName)).orElse(null);
    }

    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle jdbcTableHandle) {
        return JdbcMetadataCache.get(this.columnHandlesCache, new KeyAndSession<JdbcTableHandle>(session, jdbcTableHandle));
    }

    private Optional<JdbcTableHandle> loadTableHandle(KeyAndSession<SchemaTableName> tableName) {
        return Optional.ofNullable(this.jdbcClient.getTableHandle(tableName.getSession(), JdbcIdentity.from(tableName.getSession()), tableName.getKey()));
    }

    private List<JdbcColumnHandle> loadColumnHandles(KeyAndSession<JdbcTableHandle> tableHandle) {
        return this.jdbcClient.getColumns(tableHandle.getSession(), tableHandle.getKey());
    }

    private static CacheBuilder<Object, Object> newCacheBuilder(OptionalLong expiresAfterWriteMillis, OptionalLong refreshMillis, long maximumSize) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (expiresAfterWriteMillis.isPresent()) {
            cacheBuilder = cacheBuilder.expireAfterWrite(expiresAfterWriteMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        if (refreshMillis.isPresent() && (!expiresAfterWriteMillis.isPresent() || expiresAfterWriteMillis.getAsLong() > refreshMillis.getAsLong())) {
            cacheBuilder = cacheBuilder.refreshAfterWrite(refreshMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        return cacheBuilder.maximumSize(maximumSize).recordStats();
    }

    private static <K, V> V get(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.getUnchecked(key);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw e;
        }
    }

    private static class KeyAndSession<T> {
        private final ConnectorSession session;
        private final T key;

        public KeyAndSession(ConnectorSession session, T key) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.key = Objects.requireNonNull(key, "key is null");
        }

        public ConnectorSession getSession() {
            return this.session;
        }

        public T getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyAndSession other = (KeyAndSession)o;
            return Objects.equals(this.key, other.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("session", (Object)this.session).add("key", this.key).toString();
        }
    }
}

