/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcIdentity;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.facebook.presto.plugin.jdbc.JdbcSplit;
import com.facebook.presto.plugin.jdbc.JdbcTableHandle;
import com.facebook.presto.plugin.jdbc.JdbcTableLayoutHandle;
import com.facebook.presto.plugin.jdbc.JdbcTypeHandle;
import com.facebook.presto.plugin.jdbc.ReadMapping;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.statistics.TableStatistics;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public interface JdbcClient {
    default public boolean schemaExists(JdbcIdentity identity, String schema) {
        return this.getSchemaNames(identity).contains(schema);
    }

    public String getIdentifierQuote();

    public Set<String> getSchemaNames(JdbcIdentity var1);

    public List<SchemaTableName> getTableNames(JdbcIdentity var1, Optional<String> var2);

    @Nullable
    public JdbcTableHandle getTableHandle(JdbcIdentity var1, SchemaTableName var2);

    public List<JdbcColumnHandle> getColumns(ConnectorSession var1, JdbcTableHandle var2);

    public Optional<ReadMapping> toPrestoType(ConnectorSession var1, JdbcTypeHandle var2);

    public ConnectorSplitSource getSplits(JdbcIdentity var1, JdbcTableLayoutHandle var2);

    public Connection getConnection(JdbcIdentity var1, JdbcSplit var2) throws SQLException;

    default public void abortReadConnection(Connection connection) throws SQLException {
    }

    public PreparedStatement buildSql(ConnectorSession var1, Connection var2, JdbcSplit var3, List<JdbcColumnHandle> var4) throws SQLException;

    public void addColumn(JdbcIdentity var1, JdbcTableHandle var2, ColumnMetadata var3);

    public void dropColumn(JdbcIdentity var1, JdbcTableHandle var2, JdbcColumnHandle var3);

    public void renameColumn(JdbcIdentity var1, JdbcTableHandle var2, JdbcColumnHandle var3, String var4);

    public void renameTable(JdbcIdentity var1, JdbcTableHandle var2, SchemaTableName var3);

    public void createTable(ConnectorSession var1, ConnectorTableMetadata var2);

    public JdbcOutputTableHandle beginCreateTable(ConnectorSession var1, ConnectorTableMetadata var2);

    public void commitCreateTable(JdbcIdentity var1, JdbcOutputTableHandle var2);

    public JdbcOutputTableHandle beginInsertTable(ConnectorSession var1, ConnectorTableMetadata var2);

    public void finishInsertTable(JdbcIdentity var1, JdbcOutputTableHandle var2);

    public void dropTable(JdbcIdentity var1, JdbcTableHandle var2);

    public void truncateTable(JdbcIdentity var1, JdbcTableHandle var2);

    public void rollbackCreateTable(JdbcIdentity var1, JdbcOutputTableHandle var2);

    public String buildInsertSql(JdbcOutputTableHandle var1);

    public Connection getConnection(JdbcIdentity var1, JdbcOutputTableHandle var2) throws SQLException;

    public PreparedStatement getPreparedStatement(Connection var1, String var2) throws SQLException;

    public TableStatistics getTableStatistics(ConnectorSession var1, JdbcTableHandle var2, List<JdbcColumnHandle> var3, TupleDomain<ColumnHandle> var4);
}

