/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc.optimization.function;

import com.facebook.presto.plugin.jdbc.optimization.JdbcExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class JdbcTranslationUtil {
    private JdbcTranslationUtil() {
    }

    public static String infixOperation(String operator, JdbcExpression left, JdbcExpression right) {
        return String.format("(%s %s %s)", left.getExpression(), operator, right.getExpression());
    }

    public static List<ConstantExpression> forwardBindVariables(JdbcExpression ... jdbcExpressions) {
        return (List)Arrays.stream(jdbcExpressions).map(JdbcExpression::getBoundConstantValues).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }
}

