/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcMetadata;
import com.facebook.presto.plugin.jdbc.JdbcMetadataFactory;
import com.facebook.presto.plugin.jdbc.JdbcPageSinkProvider;
import com.facebook.presto.plugin.jdbc.JdbcRecordSetProvider;
import com.facebook.presto.plugin.jdbc.JdbcSplitManager;
import com.facebook.presto.plugin.jdbc.JdbcTransactionHandle;
import com.facebook.presto.plugin.jdbc.optimization.JdbcPlanOptimizerProvider;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorCapabilities;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPlanOptimizerProvider;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.procedure.Procedure;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class JdbcConnector
implements Connector {
    private static final Logger log = Logger.get(JdbcConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final JdbcMetadataFactory jdbcMetadataFactory;
    private final JdbcSplitManager jdbcSplitManager;
    private final JdbcRecordSetProvider jdbcRecordSetProvider;
    private final JdbcPageSinkProvider jdbcPageSinkProvider;
    private final Optional<ConnectorAccessControl> accessControl;
    private final Set<Procedure> procedures;
    private final ConcurrentMap<ConnectorTransactionHandle, JdbcMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, JdbcMetadata>();
    private final FunctionMetadataManager functionManager;
    private final StandardFunctionResolution functionResolution;
    private final RowExpressionService rowExpressionService;
    private final JdbcClient jdbcClient;

    @Inject
    public JdbcConnector(LifeCycleManager lifeCycleManager, JdbcMetadataFactory jdbcMetadataFactory, JdbcSplitManager jdbcSplitManager, JdbcRecordSetProvider jdbcRecordSetProvider, JdbcPageSinkProvider jdbcPageSinkProvider, Optional<ConnectorAccessControl> accessControl, Set<Procedure> procedures, FunctionMetadataManager functionManager, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, JdbcClient jdbcClient) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.jdbcMetadataFactory = Objects.requireNonNull(jdbcMetadataFactory, "jdbcMetadataFactory is null");
        this.jdbcSplitManager = Objects.requireNonNull(jdbcSplitManager, "jdbcSplitManager is null");
        this.jdbcRecordSetProvider = Objects.requireNonNull(jdbcRecordSetProvider, "jdbcRecordSetProvider is null");
        this.jdbcPageSinkProvider = Objects.requireNonNull(jdbcPageSinkProvider, "jdbcPageSinkProvider is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.procedures = ImmutableSet.copyOf((Collection)Objects.requireNonNull(procedures, "procedures is null"));
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.rowExpressionService = Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
    }

    public ConnectorPlanOptimizerProvider getConnectorPlanOptimizerProvider() {
        return new JdbcPlanOptimizerProvider(this.jdbcClient, this.functionManager, this.functionResolution, this.rowExpressionService.getDeterminismEvaluator(), this.rowExpressionService.getExpressionOptimizer());
    }

    public boolean isSingleStatementWritesOnly() {
        return true;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        JdbcTransactionHandle transaction = new JdbcTransactionHandle();
        this.transactions.put(transaction, this.jdbcMetadataFactory.create());
        return transaction;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
        JdbcMetadata metadata = (JdbcMetadata)this.transactions.get(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        return new ClassLoaderSafeConnectorMetadata((ConnectorMetadata)metadata, this.getClass().getClassLoader());
    }

    public void commit(ConnectorTransactionHandle transaction) {
        Preconditions.checkArgument((this.transactions.remove(transaction) != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        JdbcMetadata metadata = (JdbcMetadata)this.transactions.remove(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        metadata.rollback();
    }

    public ConnectorSplitManager getSplitManager() {
        return this.jdbcSplitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.jdbcRecordSetProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.jdbcPageSinkProvider;
    }

    public ConnectorAccessControl getAccessControl() {
        return this.accessControl.orElseThrow(UnsupportedOperationException::new);
    }

    public Set<Procedure> getProcedures() {
        return this.procedures;
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }

    public Set<ConnectorCapabilities> getCapabilities() {
        return Sets.immutableEnumSet((Enum)ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT, (Enum[])new ConnectorCapabilities[0]);
    }
}

