/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.plugin.jdbc.JdbcTypeHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.Objects;

public final class JdbcColumnHandle
implements ColumnHandle {
    private final String connectorId;
    private final String columnName;
    private final JdbcTypeHandle jdbcTypeHandle;
    private final Type columnType;
    private final boolean nullable;

    @JsonCreator
    public JdbcColumnHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="columnName") String columnName, @JsonProperty(value="jdbcTypeHandle") JdbcTypeHandle jdbcTypeHandle, @JsonProperty(value="columnType") Type columnType, @JsonProperty(value="nullable") boolean nullable) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.jdbcTypeHandle = Objects.requireNonNull(jdbcTypeHandle, "jdbcTypeHandle is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.nullable = nullable;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public JdbcTypeHandle getJdbcTypeHandle() {
        return this.jdbcTypeHandle;
    }

    @JsonProperty
    public Type getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public boolean isNullable() {
        return this.nullable;
    }

    public ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(this.columnName, this.columnType, this.nullable, null, null, false, Collections.emptyMap());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JdbcColumnHandle o = (JdbcColumnHandle)obj;
        return Objects.equals(this.connectorId, o.connectorId) && Objects.equals(this.columnName, o.columnName);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.columnName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("columnName", (Object)this.columnName).add("jdbcTypeHandle", (Object)this.jdbcTypeHandle).add("columnType", (Object)this.columnType).add("nullable", this.nullable).toString();
    }
}

