/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc.optimization;

import com.facebook.presto.expressions.translator.FunctionTranslator;
import com.facebook.presto.expressions.translator.RowExpressionTranslator;
import com.facebook.presto.expressions.translator.RowExpressionTreeTranslator;
import com.facebook.presto.expressions.translator.TranslatedExpression;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.optimization.JdbcExpression;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class JdbcFilterToSqlTranslator
extends RowExpressionTranslator<JdbcExpression, Map<VariableReferenceExpression, ColumnHandle>> {
    private final FunctionMetadataManager functionMetadataManager;
    private final FunctionTranslator<JdbcExpression> functionTranslator;
    private final String quote;

    public JdbcFilterToSqlTranslator(FunctionMetadataManager functionMetadataManager, FunctionTranslator<JdbcExpression> functionTranslator, String quote) {
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "functionMetadataManager is null");
        this.functionTranslator = Objects.requireNonNull(functionTranslator, "functionTranslator is null");
        this.quote = Objects.requireNonNull(quote, "quote is null");
    }

    public TranslatedExpression<JdbcExpression> translateConstant(ConstantExpression literal, Map<VariableReferenceExpression, ColumnHandle> context, RowExpressionTreeTranslator<JdbcExpression, Map<VariableReferenceExpression, ColumnHandle>> rowExpressionTreeTranslator) {
        if (JdbcFilterToSqlTranslator.isSupportedType(literal.getType())) {
            return new TranslatedExpression(Optional.of(new JdbcExpression("?", (List<ConstantExpression>)ImmutableList.of((Object)literal))), (RowExpression)literal, (List)ImmutableList.of());
        }
        return TranslatedExpression.untranslated((RowExpression)literal);
    }

    public TranslatedExpression<JdbcExpression> translateVariable(VariableReferenceExpression variable, Map<VariableReferenceExpression, ColumnHandle> context, RowExpressionTreeTranslator<JdbcExpression, Map<VariableReferenceExpression, ColumnHandle>> rowExpressionTreeTranslator) {
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)context.get(variable);
        Objects.requireNonNull(columnHandle, String.format("Unrecognized variable %s", variable));
        return new TranslatedExpression(Optional.of(new JdbcExpression(this.quote + columnHandle.getColumnName().replace(this.quote, this.quote + this.quote) + this.quote)), (RowExpression)variable, (List)ImmutableList.of());
    }

    public TranslatedExpression<JdbcExpression> translateLambda(LambdaDefinitionExpression lambda, Map<VariableReferenceExpression, ColumnHandle> context, RowExpressionTreeTranslator<JdbcExpression, Map<VariableReferenceExpression, ColumnHandle>> rowExpressionTreeTranslator) {
        return TranslatedExpression.untranslated((RowExpression)lambda);
    }

    public TranslatedExpression<JdbcExpression> translateCall(CallExpression call, Map<VariableReferenceExpression, ColumnHandle> context, RowExpressionTreeTranslator<JdbcExpression, Map<VariableReferenceExpression, ColumnHandle>> rowExpressionTreeTranslator) {
        List translatedExpressions = (List)call.getArguments().stream().map(expression -> rowExpressionTreeTranslator.rewrite(expression, (Object)context)).collect(ImmutableList.toImmutableList());
        FunctionMetadata functionMetadata = this.functionMetadataManager.getFunctionMetadata(call.getFunctionHandle());
        try {
            return this.functionTranslator.translate(functionMetadata, (RowExpression)call, translatedExpressions);
        }
        catch (Throwable throwable) {
            return TranslatedExpression.untranslated((RowExpression)call, (List)translatedExpressions);
        }
    }

    public TranslatedExpression<JdbcExpression> translateSpecialForm(SpecialFormExpression specialForm, Map<VariableReferenceExpression, ColumnHandle> context, RowExpressionTreeTranslator<JdbcExpression, Map<VariableReferenceExpression, ColumnHandle>> rowExpressionTreeTranslator) {
        List translatedExpressions = (List)specialForm.getArguments().stream().map(expression -> rowExpressionTreeTranslator.rewrite(expression, (Object)context)).collect(ImmutableList.toImmutableList());
        List jdbcExpressions = (List)translatedExpressions.stream().map(TranslatedExpression::getTranslated).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
        if (jdbcExpressions.size() < translatedExpressions.size()) {
            return TranslatedExpression.untranslated((RowExpression)specialForm, (List)translatedExpressions);
        }
        List sqlBodies = (List)jdbcExpressions.stream().map(JdbcExpression::getExpression).map(sql -> '(' + sql + ')').collect(ImmutableList.toImmutableList());
        List variableBindings = (List)jdbcExpressions.stream().map(JdbcExpression::getBoundConstantValues).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        switch (specialForm.getForm()) {
            case AND: {
                return new TranslatedExpression(Optional.of(new JdbcExpression(String.format("(%s)", Joiner.on((String)" AND ").join((Iterable)sqlBodies)), variableBindings)), (RowExpression)specialForm, translatedExpressions);
            }
            case OR: {
                return new TranslatedExpression(Optional.of(new JdbcExpression(String.format("(%s)", Joiner.on((String)" OR ").join((Iterable)sqlBodies)), variableBindings)), (RowExpression)specialForm, translatedExpressions);
            }
            case IN: {
                return new TranslatedExpression(Optional.of(new JdbcExpression(String.format("(%s IN (%s))", sqlBodies.get(0), Joiner.on((String)" , ").join(sqlBodies.subList(1, sqlBodies.size()))), variableBindings)), (RowExpression)specialForm, translatedExpressions);
            }
        }
        return TranslatedExpression.untranslated((RowExpression)specialForm, (List)translatedExpressions);
    }

    private static boolean isSupportedType(Type type) {
        Type validType = Objects.requireNonNull(type, "type is null");
        return validType.equals(BigintType.BIGINT) || validType.equals(TinyintType.TINYINT) || validType.equals(SmallintType.SMALLINT) || validType.equals(IntegerType.INTEGER) || validType.equals(DoubleType.DOUBLE) || validType.equals(RealType.REAL) || validType.equals(BooleanType.BOOLEAN) || validType.equals(DateType.DATE) || validType.equals(TimeType.TIME) || validType.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) || validType.equals(TimestampType.TIMESTAMP) || validType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) || validType instanceof VarcharType || validType instanceof CharType;
    }
}

