/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.BooleanReadFunction;
import com.facebook.presto.plugin.jdbc.DoubleReadFunction;
import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcSplit;
import com.facebook.presto.plugin.jdbc.LongReadFunction;
import com.facebook.presto.plugin.jdbc.ReadFunction;
import com.facebook.presto.plugin.jdbc.ReadMapping;
import com.facebook.presto.plugin.jdbc.SliceReadFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.VerifyException;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class JdbcRecordCursor
implements RecordCursor {
    private static final Logger log = Logger.get(JdbcRecordCursor.class);
    private final JdbcColumnHandle[] columnHandles;
    private final BooleanReadFunction[] booleanReadFunctions;
    private final DoubleReadFunction[] doubleReadFunctions;
    private final LongReadFunction[] longReadFunctions;
    private final SliceReadFunction[] sliceReadFunctions;
    private final Connection connection;
    private final PreparedStatement statement;
    private final ResultSet resultSet;
    private boolean closed;

    public JdbcRecordCursor(JdbcClient jdbcClient, ConnectorSession session, JdbcSplit split, List<JdbcColumnHandle> columnHandles) {
        this.columnHandles = columnHandles.toArray(new JdbcColumnHandle[0]);
        this.booleanReadFunctions = new BooleanReadFunction[columnHandles.size()];
        this.doubleReadFunctions = new DoubleReadFunction[columnHandles.size()];
        this.longReadFunctions = new LongReadFunction[columnHandles.size()];
        this.sliceReadFunctions = new SliceReadFunction[columnHandles.size()];
        for (int i = 0; i < this.columnHandles.length; ++i) {
            ReadMapping readMapping = jdbcClient.toPrestoType(session, columnHandles.get(i).getJdbcTypeHandle()).orElseThrow(() -> new VerifyException("Unsupported column type"));
            Class javaType = readMapping.getType().getJavaType();
            ReadFunction readFunction = readMapping.getReadFunction();
            if (javaType == Boolean.TYPE) {
                this.booleanReadFunctions[i] = (BooleanReadFunction)readFunction;
                continue;
            }
            if (javaType == Double.TYPE) {
                this.doubleReadFunctions[i] = (DoubleReadFunction)readFunction;
                continue;
            }
            if (javaType == Long.TYPE) {
                this.longReadFunctions[i] = (LongReadFunction)readFunction;
                continue;
            }
            if (javaType == Slice.class) {
                this.sliceReadFunctions[i] = (SliceReadFunction)readFunction;
                continue;
            }
            throw new IllegalStateException(String.format("Unsupported java type %s", javaType));
        }
        try {
            this.connection = jdbcClient.getConnection(split);
            this.statement = jdbcClient.buildSql(this.connection, split, columnHandles);
            log.debug("Executing: %s", new Object[]{this.statement.toString()});
            this.resultSet = this.statement.executeQuery();
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public Type getType(int field) {
        return this.columnHandles[field].getColumnType();
    }

    public boolean advanceNextPosition() {
        if (this.closed) {
            return false;
        }
        try {
            boolean result = this.resultSet.next();
            if (!result) {
                this.close();
            }
            return result;
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public boolean getBoolean(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        try {
            return this.booleanReadFunctions[field].readBoolean(this.resultSet, field + 1);
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public long getLong(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        try {
            return this.longReadFunctions[field].readLong(this.resultSet, field + 1);
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public double getDouble(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        try {
            return this.doubleReadFunctions[field].readDouble(this.resultSet, field + 1);
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public Slice getSlice(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        try {
            return this.sliceReadFunctions[field].readSlice(this.resultSet, field + 1);
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public Object getObject(int field) {
        throw new UnsupportedOperationException();
    }

    public boolean isNull(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        Preconditions.checkArgument((field < this.columnHandles.length ? 1 : 0) != 0, (Object)"Invalid field index");
        try {
            this.resultSet.getObject(field + 1);
            return this.resultSet.wasNull();
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try (Connection connection = this.connection;
             PreparedStatement statement = this.statement;){
            ResultSet resultSet = this.resultSet;
            Throwable throwable = null;
            if (resultSet != null) {
                if (throwable != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    resultSet.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private RuntimeException handleSqlException(Exception e) {
        block2: {
            try {
                this.close();
            }
            catch (Exception closeException) {
                if (e == closeException) break block2;
                e.addSuppressed(closeException);
            }
        }
        return Throwables.propagate((Throwable)e);
    }
}

