/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcErrorCode;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordSink;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public class JdbcRecordSink
implements RecordSink {
    private final Connection connection;
    private final PreparedStatement statement;
    private final int fieldCount;
    private final List<Type> columnTypes;
    private int field = -1;
    private int batchSize;

    public JdbcRecordSink(JdbcOutputTableHandle handle, JdbcClient jdbcClient) {
        try {
            this.connection = jdbcClient.getConnection(handle);
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        try {
            this.statement = this.connection.prepareStatement(jdbcClient.buildInsertSql(handle));
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        this.fieldCount = handle.getColumnNames().size();
        this.columnTypes = handle.getColumnTypes();
    }

    public void beginRecord() {
        Preconditions.checkState((this.field == -1 ? 1 : 0) != 0, (Object)"already in record");
        this.field = 0;
    }

    public void finishRecord() {
        Preconditions.checkState((this.field != -1 ? 1 : 0) != 0, (Object)"not in record");
        Preconditions.checkState((this.field == this.fieldCount ? 1 : 0) != 0, (Object)"not all fields set");
        this.field = -1;
        try {
            this.statement.addBatch();
            ++this.batchSize;
            if (this.batchSize >= 1000) {
                this.statement.executeBatch();
                this.connection.commit();
                this.connection.setAutoCommit(false);
                this.batchSize = 0;
            }
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public void appendNull() {
        try {
            this.statement.setObject(this.next(), null);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public void appendBoolean(boolean value) {
        try {
            this.statement.setBoolean(this.next(), value);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public void appendLong(long value) {
        try {
            if (DateType.DATE.equals((Object)this.columnTypes.get(this.field))) {
                long utcMillis = TimeUnit.DAYS.toMillis(value);
                long localMillis = ISOChronology.getInstanceUTC().getZone().getMillisKeepLocal(DateTimeZone.getDefault(), utcMillis);
                this.statement.setDate(this.next(), new Date(localMillis));
            } else {
                this.statement.setLong(this.next(), value);
            }
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public void appendDouble(double value) {
        try {
            this.statement.setDouble(this.next(), value);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public void appendString(byte[] value) {
        try {
            this.statement.setString(this.next(), new String(value, StandardCharsets.UTF_8));
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public void appendObject(Object value) {
        throw new UnsupportedOperationException();
    }

    public Collection<Slice> commit() {
        try (Connection connection = this.connection;){
            if (this.batchSize > 0) {
                this.statement.executeBatch();
                connection.commit();
            }
        }
        catch (SQLNonTransientException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_NON_TRANSIENT_ERROR, (Throwable)e);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        return ImmutableList.of();
    }

    public void rollback() {
        try (Connection connection = this.connection;
             PreparedStatement statement = this.statement;){
            connection.rollback();
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    private int next() {
        Preconditions.checkState((this.field != -1 ? 1 : 0) != 0, (Object)"not in record");
        Preconditions.checkState((this.field < this.fieldCount ? 1 : 0) != 0, (Object)"all fields already set");
        ++this.field;
        return this.field;
    }
}

