/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcSplit;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public class JdbcRecordCursor
implements RecordCursor {
    private static final Logger log = Logger.get(JdbcRecordCursor.class);
    private static final ISOChronology UTC_CHRONOLOGY = ISOChronology.getInstance((DateTimeZone)DateTimeZone.UTC);
    private final List<JdbcColumnHandle> columnHandles;
    private final Connection connection;
    private final PreparedStatement statement;
    private final ResultSet resultSet;
    private boolean closed;

    public JdbcRecordCursor(JdbcClient jdbcClient, JdbcSplit split, List<JdbcColumnHandle> columnHandles) {
        this.columnHandles = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnHandles, "columnHandles is null"));
        try {
            this.connection = jdbcClient.getConnection(split);
            this.statement = jdbcClient.buildSql(split, columnHandles);
            log.debug("Executing: %s", new Object[]{this.statement.toString()});
            this.resultSet = this.statement.executeQuery();
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public long getTotalBytes() {
        return 0L;
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public Type getType(int field) {
        return this.columnHandles.get(field).getColumnType();
    }

    public boolean advanceNextPosition() {
        if (this.closed) {
            return false;
        }
        try {
            boolean result = this.resultSet.next();
            if (!result) {
                this.close();
            }
            return result;
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public boolean getBoolean(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        try {
            return this.resultSet.getBoolean(field + 1);
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public long getLong(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        try {
            Type type = this.getType(field);
            if (type.equals(TinyintType.TINYINT)) {
                return this.resultSet.getByte(field + 1);
            }
            if (type.equals(SmallintType.SMALLINT)) {
                return this.resultSet.getShort(field + 1);
            }
            if (type.equals(IntegerType.INTEGER)) {
                return this.resultSet.getInt(field + 1);
            }
            if (type.equals(RealType.REAL)) {
                return Float.floatToRawIntBits(this.resultSet.getFloat(field + 1));
            }
            if (type.equals(BigintType.BIGINT)) {
                return this.resultSet.getLong(field + 1);
            }
            if (type.equals(DateType.DATE)) {
                long localMillis = this.resultSet.getDate(field + 1).getTime();
                long utcMillis = ISOChronology.getInstance().getZone().getMillisKeepLocal(DateTimeZone.UTC, localMillis);
                return TimeUnit.MILLISECONDS.toDays(utcMillis);
            }
            if (type.equals(TimeType.TIME)) {
                Time time = this.resultSet.getTime(field + 1);
                return UTC_CHRONOLOGY.millisOfDay().get(time.getTime());
            }
            if (type.equals(TimestampType.TIMESTAMP)) {
                Timestamp timestamp = this.resultSet.getTimestamp(field + 1);
                return timestamp.getTime();
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for long: " + type.getTypeSignature());
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public double getDouble(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        try {
            return this.resultSet.getDouble(field + 1);
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public Slice getSlice(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        try {
            Type type = this.getType(field);
            if (type instanceof VarcharType) {
                return Slices.utf8Slice((String)this.resultSet.getString(field + 1));
            }
            if (type instanceof CharType) {
                return Slices.utf8Slice((String)CharMatcher.is((char)' ').trimTrailingFrom((CharSequence)this.resultSet.getString(field + 1)));
            }
            if (type.equals(VarbinaryType.VARBINARY)) {
                return Slices.wrappedBuffer((byte[])this.resultSet.getBytes(field + 1));
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for slice: " + type.getTypeSignature());
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public Object getObject(int field) {
        throw new UnsupportedOperationException();
    }

    public boolean isNull(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        try {
            this.resultSet.getObject(field + 1);
            return this.resultSet.wasNull();
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try (Connection connection = this.connection;
             PreparedStatement statement = this.statement;){
            ResultSet resultSet = this.resultSet;
            Throwable throwable = null;
            if (resultSet != null) {
                if (throwable != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    resultSet.close();
                }
            }
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private RuntimeException handleSqlException(Exception e) {
        block2: {
            try {
                this.close();
            }
            catch (Exception closeException) {
                if (e == closeException) break block2;
                e.addSuppressed(closeException);
            }
        }
        return Throwables.propagate((Throwable)e);
    }
}

